#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);
use Test::More;
use Test::Differences qw(eq_or_diff);

use Test::Partner::Utils qw(request_to_api eq_or_diff_http_message);

use qbit;

my $MOCKED_BK_ANSWER = q({
   "data" : {
      "tree" : [
         {
            "conflict_fields" : [],
            "dimension_fields" : [],
            "entity_fields" : [],
            "entity_filter_fields" : {},
            "entity_filter_simple_fields" : [],
            "fields" : [],
            "has_product" : "",
            "has_raw_stat" : "",
            "id" : "payment",
            "title" : "Вознаграждения"
         }
      ]
   },
   "result" : "ok"
});

run_tests(
    sub {
        my ($app) = @_;

        $app->bk_statistics;
        mock_subs(
            {
                'Application::Model::BKStatistics::get_tree2' => sub {
                    my ($self, %opts) = @_;
                    return from_json($MOCKED_BK_ANSWER)->{data};
                  }
            }
        );

        my ($stdout, $stderr, $exit_status) = request_to_api(
            app          => $app,
            path         => 'statistics2',
            method       => 'tree',
            ext          => 'json',
            query_string => 'lang=C&oauth_token=mocked-yan-partner&pretty=1',
        );

        is($exit_status, 1, 'exit status');

        eq_or_diff($stderr, '', 'stderr', {context => 1});

        eq_or_diff_http_message(
            $stdout, "Status: 200 OK
X-Content-Type-Options: nosniff
X-Yandex-Login: mocked-yan-partner
Content-Type: application/json; charset=UTF-8

$MOCKED_BK_ANSWER
", 'stdout', {context => 10}
        );
    },
    application_package => 'API',
);
