#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Differences;
use Test::Exception;
use Test::More tests => 11;

use Exception::API::AdFoxGraphQL;
use Exception::Validator::Errors;
use Test::Partner2::Simple;

my %normal_args = (
    adfox_login => 'traden',
    user_id     => 123456,
    presets     => ['PAIDPRODUCTS'],
);
my %normal_args_wbilling = (
    adfox_login  => 'traden',
    user_id      => 123456,
    presets      => ['PAIDPRODUCTS'],
    billing_data => {
        client_id   => 666,
        contract_id => 667,
    }
);
my $normal_query = {
    query => '
mutation ($adfoxAccount: NonEmptyString!, $passportUid: Int64!, $presets: [RegistrationPreset!]) {
    AdfoxInternal {
        bindClient(adfoxAccount: $adfoxAccount, passportUid: $passportUid, presets: $presets) {
            id,
            login
        }
    }
}',
    variables => {
        adfoxAccount => 'traden',
        passportUid  => '123456',
        presets      => ['PAIDPRODUCTS'],
    },
};
my $normal_query_wbilling = {
    query => '
mutation ($adfoxAccount: NonEmptyString!, $passportUid: Int64!, $presets: [RegistrationPreset!], $billingClientId: Int!, $billingContractId: Int!) {
    AdfoxInternal {
        bindClient(
            adfoxAccount: $adfoxAccount,
            passportUid: $passportUid,
            presets: $presets,
            billingData: {
                billingClientId: $billingClientId,
                billingContractId: $billingContractId
            },
        ) {
            id,
            login
        }
    }
}',
    variables => {
        adfoxAccount      => 'traden',
        passportUid       => '123456',
        presets           => ['PAIDPRODUCTS'],
        billingClientId   => 666,
        billingContractId => 667,
    },
};

run_tests(
    sub {
        my ($app) = @_;

        my $api = $app->api_adfox_graphql;
        $api->set_option('mock', FALSE);

        no warnings 'redefine';
        no strict 'refs';

        local *{'LWP::UserAgent::request'};

        *{'LWP::UserAgent::request'} = sub {
            my ($self, $request) = @_;
            eq_or_diff(from_json($request->content()), $normal_query, 'call: Get expected request',);
            is($request->method(), 'POST', 'call: Get expected request method',);
            my $r = HTTP::Response->new(200);
            $r->request(HTTP::Request->new());
            $r->content('{"data":{"AdfoxInternal":{"bindClient":{"id":654321,"login":"mocked_adfox_login"}}}}');
            return $r;
        };
        eq_or_diff(
            $api->bind_user(%normal_args),
            {
                id    => 654321,
                login => 'mocked_adfox_login',
            },
            'Get expected answer'
        );

        *{'LWP::UserAgent::request'} = sub {
            my ($self, $request) = @_;
            eq_or_diff(from_json($request->content()), $normal_query_wbilling, 'call: Get expected request',);
            is($request->method(), 'POST', 'call: Get expected request method',);
            my $r = HTTP::Response->new(200);
            $r->request(HTTP::Request->new());
            $r->content('{"data":{"AdfoxInternal":{"bindClient":{"id":654321,"login":"mocked_adfox_login"}}}}');
            return $r;
        };
        eq_or_diff(
            $api->bind_user(%normal_args_wbilling),
            {
                id    => 654321,
                login => 'mocked_adfox_login',
            },
            'Get expected answer'
        );

        *{'LWP::UserAgent::request'} = sub {
            my $r = HTTP::Response->new(200);
            $r->request(HTTP::Request->new());
            $r->content('{"data":{"AdfoxInternal":{"bindClient":{"login":"mocked_adfox_login"}}}}');
            return $r;
        };
        throws_ok {
            $api->bind_user(%normal_args);
        }
        'Exception::API::AdFoxGraphQL', 'Correct exception while Incorrect answer (id)';
        eq_or_diff($@->message(), 'Incorrect answer', 'Get Incorrect answer (id)');

        *{'LWP::UserAgent::request'} = sub {
            my $r = HTTP::Response->new(200);
            $r->request(HTTP::Request->new());
            $r->content('{"data":{"AdfoxInternal":{"bindClient":{"id":654321}}}}');
            return $r;
        };
        throws_ok {
            $api->bind_user(%normal_args);
        }
        'Exception::API::AdFoxGraphQL', 'Correct exception while Incorrect answer (login)';
        eq_or_diff($@->message(), 'Incorrect answer', 'Get Incorrect answer (login)');
    },
    init                 => [qw( api_adfox_graphql )],
    dont_create_database => TRUE,
);
