#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Differences;
use Test::Exception;
use Test::More tests => 6;

use Exception::API::AdFoxGraphQL;
use Exception::Validator::Errors;
use Test::Partner2::Simple;

my %valid_args = (
    user_id      => 123456,
    billing_data => {
        client_id   => 111,
        contract_id => 111,
    },
);
my $normal_query = {
    query => '
mutation ($passportUid: Int64!, $billingClientId: Int!, $billingContractId: Int!, $presets: [RegistrationPreset!]) {
  AdfoxInternal{
    setBillingData(
        passportUid: $passportUid,
        presets: $presets,
        billingData: {
            billingClientId: $billingClientId,
            billingContractId: $billingContractId
        }
    )
  }
}',
    variables => {
        passportUid       => '123456',
        billingClientId   => 111,
        billingContractId => 111,
        presets           => ['PAIDPRODUCTS']
    }
};

run_tests(
    sub {
        my ($app) = @_;

        my $api = $app->api_adfox_graphql;
        $api->set_option('mock', FALSE);

        no warnings 'redefine';
        no strict 'refs';

        local *{'LWP::UserAgent::request'};

        *{'LWP::UserAgent::request'} = sub {
            my ($self, $request) = @_;
            eq_or_diff(from_json($request->content()), $normal_query, 'call: Get expected request',);
            is($request->method(), 'POST', 'call: Get expected request method',);
            my $r = HTTP::Response->new(200);
            $r->request(HTTP::Request->new());
            $r->content('{"data":{"AdfoxInternal":{"setBillingData":true}}}');
            return $r;
        };

        eq_or_diff($api->set_billing_data(%valid_args), from_json('true'), 'Get expected answer');

        *{'LWP::UserAgent::request'} = sub {
            my $r = HTTP::Response->new(200);
            $r->request(HTTP::Request->new());
            $r->content('{"errors":[{"message":"adfox error message","code":34404}],"data":{"AdfoxInternal":null}}');
            return $r;
        };
        throws_ok {
            $api->set_billing_data(%valid_args),;
        }
        'Exception::API::AdFoxGraphQL', 'Correct exception on errors in answer';
        eq_or_diff($@->message(), 'adfox error message', 'Correct exception message on errors in answer');

    },
    init                 => [qw( api_adfox_graphql )],
    dont_create_database => TRUE,
);
