#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Differences;
use Test::Exception;
use Test::More tests => 6;

use Exception::API::AdFoxGraphQL;
use Exception::Validator::Errors;
use Test::Partner2::Simple;

my %normal_args = (
    adfox_id => 123456,
    presets  => ['PAIDPRODUCTS'],
);
my $normal_query = {
    query => '
mutation ($adfoxUserId: Int!, $presets: [RegistrationPreset!]) {
    AdfoxInternal {
        setPresets(adfoxUserId: $adfoxUserId, presets: $presets)
    }
}',
    variables => {
        adfoxUserId => 123456,
        presets     => ['PAIDPRODUCTS'],
    },
};

run_tests(
    sub {
        my ($app) = @_;

        my $api = $app->api_adfox_graphql;
        $api->set_option('mock', FALSE);

        no warnings 'redefine';
        no strict 'refs';

        local *{'LWP::UserAgent::request'};

        *{'LWP::UserAgent::request'} = sub {
            my ($self, $request) = @_;
            eq_or_diff(from_json($request->content()), $normal_query, 'call: Get expected request',);
            is($request->method(), 'POST', 'call: Get expected request method',);
            my $r = HTTP::Response->new(200);
            $r->request(HTTP::Request->new());
            $r->content('{"data":{"AdfoxInternal":{"setPresets":true}}}');
            return $r;
        };
        eq_or_diff($api->set_presets(%normal_args), 1, 'Get expected answer');

        *{'LWP::UserAgent::request'} = sub {
            my $r = HTTP::Response->new(200);
            $r->request(HTTP::Request->new());
            $r->content('{"data":{"AdfoxInternal":{"setPresets":false}}}');
            return $r;
        };
        throws_ok {
            $api->set_presets(%normal_args);
        }
        'Exception::API::AdFoxGraphQL', 'Correct exception while Incorrect answer';
        eq_or_diff($@->message(), 'Incorrect answer', 'Get Incorrect answer');
    },
    init                 => [qw( api_adfox_graphql )],
    dont_create_database => TRUE,
);
