#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Partner2::Simple;
use Test::More tests => 2 + 2;
use Test::Differences;
use Test::Exception;

use Test::Partner2::Mock qw(mock_subs);

my $METHOD        = 'some_method';
my $PARAMS        = {a => 1, b => 2, c => 3,};
my $TASK_ID       = '1362355c-afa3-4656-91a0-a62922e5d229';
my $NORMAL_RESULT = {
    event_horizon => '2018-09-05 13:48:50',
    fields        => ['correct', 'week_id', 'week_name', 'count',],
    state         => 'SUCCESS',
    table         => [[1, 2448, 49, 99232555,],],
    task_id       => $TASK_ID,
};
my $ERROR_RESULT = {
    code => 159,
    data => undef,
    message =>
'Received from ch11.myt.adfox.ru:9000, 2a02:6b8:b020:4300::ce:11. DB::Exception: Timeout exceeded: elapsed 180.61648591 seconds, maximum: 180. (version 19.9.3.31 (official build))',
    name => 'Error',
};

run_tests(
    sub {
        my ($app) = @_;

        my @task_states;
        my $expected_error;

        mock_subs(
            {
                'Application::Model::API::Yandex::AdFoxRTD::_call' => sub {
                    my ($self, %opts) = @_;

                    eq_or_diff(
                        \%opts,
                        {
                            method => $METHOD,
                            params => $PARAMS,
                        },
                        'sending expected data'
                    );

                    return $TASK_ID;
                },
                'Application::Model::API::Yandex::AdFoxRTD::get_task_result' => sub {
                    my ($self, $task_id, $need_error) = @_;

                    is($task_id,    $TASK_ID,        'correct task id');
                    is($need_error, $expected_error, 'correct error state');

                    return $need_error ? $ERROR_RESULT : $NORMAL_RESULT;
                },
                'Application::Model::API::Yandex::AdFoxRTD::get_task_state' => sub {
                    my ($self, $task_id) = @_;

                    is($task_id, $TASK_ID, 'correct task id');

                    return shift @task_states;
                },
            }
        );

        subtest 'success' => sub {
            @task_states = (('PENDING') x 3, ('STARTED') x 5, 'SUCCESS');
            plan tests => 1 + scalar(@task_states) + 2 + 1;

            my $task_result = $app->api_adfox_rtd->add_task_and_get_result(
                method  => $METHOD,
                params  => $PARAMS,
                retries => 10,
            );

            eq_or_diff($task_result, $NORMAL_RESULT, 'got expected task result');
        };

        subtest 'success' => sub {
            @task_states = (('PENDING') x 3, ('STARTED') x 5, 'FAILURE');
            $expected_error = TRUE;
            my $cases = scalar(@task_states);
            plan tests => 1 + $cases + 2 + 3;

            throws_ok {
                my $task_result = $app->api_adfox_rtd->add_task_and_get_result(
                    method  => $METHOD,
                    params  => $PARAMS,
                    retries => 10,
                );
            }
            'Exception::API::AdFoxRTD', 'correct exception';

            is(
                $@->message(),
                sprintf('After 9 retries can\'t get result for Task ID %s. Last state: FAILURE', $TASK_ID),
                'correct message'
              );
            eq_or_diff(
                $@->{sentry},
                {
                    extra => {
                        add_task_and_get_result => {
                            error      => $ERROR_RESULT,
                            last_state => 'FAILURE',
                            retries    => $cases,
                            task_id    => $TASK_ID,
                        },
                    },
                },
                'additional info'
            );
        };
    },
    init => [qw(api_adfox_rtd)],
);
