use qbit;

use Test::Partner2::Simple;
use Test::More;
use Test::Deep qw(cmp_deeply);

no strict 'refs';
no warnings 'redefine';

sub expected_answer {
    my ($app) = @_;

    *{'LWP::UserAgent::request'} = sub {
        my ($ua, $request) = @_;

        cmp_deeply(
            from_json($request->content()),
            {
                id      => 1,
                jsonrpc => '2.0',
                method  => 'builder_basic',
                params  => {
                    select => ['week_id',],
                    where  => {date => ['2018-09-04', '2018-09-04']},
                },
            },
            'sending expected data to adfox',
        );

        my $response = HTTP::Response->new(200);
        $response->request(HTTP::Request->new());
        $response->content(
            to_json(
                {
                    id      => 1,
                    jsonrpc => 2.0,
                    result  => '6fa3a2e9-08bf-4046-b242-389ed8a31d82',
                }
            )
        );

        return $response;
    };

    my $task_id = $app->api_adfox_rtd->add_task_builder_basic(
        {
            select => ['week_id',],
            where  => {date => ['2018-09-04', '2018-09-04',],},
        }
    );

    cmp_deeply($task_id, '6fa3a2e9-08bf-4046-b242-389ed8a31d82', 'got expected task_id');

    return 1;
}

run_tests(
    sub {
        my ($app) = @_;

        expected_answer($app);
    },
);
