use qbit;

use Test::Partner2::Simple;
use Test::More;
use Test::Deep qw(cmp_deeply);

no strict 'refs';
no warnings 'redefine';

sub expected_answer {
    my ($app) = @_;

    *{'LWP::UserAgent::request'} = sub {
        my ($ua, $request) = @_;

        cmp_deeply(
            from_json($request->content()),
            {
                id      => 1,
                jsonrpc => '2.0',
                method  => 'get_task_state',
                params  => ['1362355c-afa3-4656-91a0-a62922e5d229',],
            },
            'sending expected data to adfox',
        );

        my $response = HTTP::Response->new(200);
        $response->request(HTTP::Request->new());
        $response->content(
            to_json(
                {
                    id      => 1,
                    jsonrpc => '2.0',
                    result  => 'SUCCESS',
                }
            )
        );

        return $response;
    };

    my $task_status = $app->api_adfox_rtd->get_task_state('1362355c-afa3-4656-91a0-a62922e5d229');

    is($task_status, 'SUCCESS', 'got expected task status');

    return 1;
}

sub invalid_answer {
    my ($app) = @_;

    *{'LWP::UserAgent::request'} = sub {
        my ($ua) = @_;

        my $response = HTTP::Response->new(200);
        $response->request(HTTP::Request->new());
        $response->content(to_json([1, 2, 3]),);

        return $response;
    };

    my $e;

    try {
        my $task_status = $app->api_adfox_rtd->get_task_state('1362355c-afa3-4656-91a0-a62922e5d229');
    }
    catch {
        $e = shift;
    };

    is(ref($e), 'Exception::API::AdFoxRTD', 'got expected exception');
    like($e->message(), qr/Unexpected answer/, 'got expected message');

    return 1;
}

sub unknown_status {
    my ($app) = @_;

    *{'LWP::UserAgent::request'} = sub {
        my ($ua) = @_;

        my $response = HTTP::Response->new(200);
        $response->request(HTTP::Request->new());
        $response->content(
            to_json(
                {
                    id      => 1,
                    jsonrpc => '2.0',
                    result  => 'SOME_UNKNOWN_STATUS',
                }
            )
        );

        return $response;
    };

    my $e;

    try {
        my $task_status = $app->api_adfox_rtd->get_task_state('1362355c-afa3-4656-91a0-a62922e5d229');
    }
    catch {
        $e = shift;
    };

    is(ref($e), 'Exception::API::AdFoxRTD', 'got expected exception');
    like($e->message(), qr/Unknown state/, 'got expected message');

    return 1;
}

run_tests(
    sub {
        my ($app) = @_;

        expected_answer($app);
        invalid_answer($app);
        unknown_status($app);

    },
);
