#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner::Utils qw(
  convert_design_to_object
  );

use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $data = [
            {
                product_id    => 'test',
                client_id     => 11010,
                banners_count => 9,
                target_type   => 3,
                places        => {},
                rtb_blocks    => {
                    '1' => {
                        "RtbDesign" => convert_design_to_object(
                            "\"blockId\":\"R-A-1262-1\",\"name\":\"300x500\",\"imagesFirst\":false")
                           },
                    '2' => {
                        "RtbDesign" => convert_design_to_object(
                            "\"blockId\":\"R-A-1262-2\",\"name\":\"160x600\",\"imagesFirst\":false")
                           },
                    '3' => {
                        "RtbDesign" => convert_design_to_object(
                            "\"blockId\":\"R-A-1262-2\",\"eman\":\"160x600\",\"imagesFirst\":false")
                           },
                }
            },
        ];

        my %result = $app->api_bk->_get_bk_data($data);

        cmp_deeply(
            $result{0}->{'RtbBlocks'}->{1}->{AllowedImageType},
            ['small', 'regular', 'wide'],
            'api_http_bk->_get_bk_data –- wide'
        );
        cmp_deeply(
            $result{0}->{'RtbBlocks'}->{2}->{AllowedImageType},
            ['small', 'regular'],
            'api_http_bk->_get_bk_data -- no wide'
        );
        cmp_deeply(
            $result{0}->{'RtbBlocks'}->{2}->{AllowedImageType},
            ['small', 'regular'],
            'api_http_bk->_get_bk_data -- no name'
        );
    },
);
