#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $data = [
            {
                product_id       => 'test',
                client_id        => 11010,
                banners_count    => 9,
                target_type      => 3,
                places           => {},
                excluded_domains => [
                    'yandex.ru',    # simple domain
                    'com.wVse_novosti_v_odnom_meste_onlayn_Agregator_novostey_Novosti_Ukrainyi_Rossii_i_novosti_mira'
                    ,                                      # long bundle id with underscores
                    'com.ihg.priorityclubrewards-test',    # apple bundle id with hyphen
                    'кремль.рф'                    # non-ascii
                ],
            },
        ];

        my %result = $app->api_bk->_get_bk_data($data);

        is(
            $result{0}{excludeddomains},
            join(',',
                'yandex.ru',
                'com.wVse_novosti_v_odnom_meste_onlayn_Agregator_novostey_Novosti_Ukrainyi_Rossii_i_novosti_mira',
                'com.ihg.priorityclubrewards-test',
                'xn--e1ajeds9e.xn--p1ai'),
            'excluded domains'
          );
    },
);
