#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $data = [
            {
                product_id    => 'test',
                client_id     => 11010,
                banners_count => 9,
                target_type   => 3,
                places        => {},
                page_options  => {'Enable' => ['ssp', 'mobile-app'], 'Disable' => ['no-turl']}
            },
        ];

        my %result = $app->api_bk->_get_bk_data($data);

        cmp_deeply($result{0}->{'PageOptions'}, $data->[0]{'page_options'}, 'api_http_bk->_get_bk_data');
    },
);
