#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Differences;

use PiConstants qw($TRANSPORTS_KVSTORE_KEYS);

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_test_data_path get_test_data_and_update_if_needed);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        # mock rand
        *CORE::GLOBAL::rand = sub {66};

        my @kv_sore_keys_to_clear = map {values %$_} values %$TRANSPORTS_KVSTORE_KEYS;

        foreach my $transport_name (keys %$TRANSPORTS_KVSTORE_KEYS) {
            my $json_file_name = sprintf('/%s.json', $transport_name);
            my $has = from_json readfile(get_test_data_path() . $json_file_name);

            my $got = [];
            foreach my $test (@$has) {
                my ($accessor, $page_id, $kv_store) = @{$test}{qw(accessor page_id kv_store)};

                # clear old params
                foreach my $key (@kv_sore_keys_to_clear) {
                    $Application::Model::API::Yandex::BK::CHI_CACHE->remove($key)
                      if $Application::Model::API::Yandex::BK::CHI_CACHE;
                    $app->kv_store->delete($key);
                }

                # set new params
                foreach my $key (keys %$kv_store) {
                    $app->kv_store->set($key, $kv_store->{$key});
                }

                my $is_send = $app->api_bk->_is_send_page_to_transport($accessor, $page_id, $transport_name);

                push @$got, {%$test, is_send => $is_send};
            }

            get_test_data_and_update_if_needed($json_file_name, $got);

            eq_or_diff($got, $has, sprintf('api_bk->_is_send_to_%s_transport', $transport_name), {context => 10});
        }
    },
);
