#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Deep;

use Test::Partner2::Simple;
use Test::MockObject::Extends::Easy;

use qbit;

my $MOCK_PAGE_ID = 12345;

run_tests(
    sub {
        my ($app) = @_;

        mock_app($app);

        my $page_id = $app->api_bk->_set_page_id_if_need_and_call('EditPage', {0 => {}});

        is($page_id, $MOCK_PAGE_ID);
    },
    init                 => [qw(api_bk api_utils_partner2)],
    dont_create_database => TRUE,
);

sub mock_app {
    my ($app) = @_;

    $app->{api_utils_partner2} = Test::MockObject::Extends::Easy->new($app->{api_utils_partner2});
    $app->api_utils_partner2->mock(
        'get_next_page_id',
        sub {
            my ($self, $method, $data) = @_;

            return $MOCK_PAGE_ID;
        }
    );

    $app->{api_bk} = Test::MockObject::Extends::Easy->new($app->{api_bk});

    $app->api_bk->mock(
        'call',
        sub {
            my ($self, $method, $data) = @_;

            cmp_deeply($data, {0 => {PageID => $MOCK_PAGE_ID}});

            return $MOCK_PAGE_ID;
        }
    );
}
