#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Deep;

use Test::Partner2::Simple;
use Test::Partner2::Mock;

run_tests(
    sub {
        my ($app) = @_;

        mock_bk($app);

        check_excludeddomains_in_context_on_site_campaign($app);
        check_excludeddomains_in_search_on_site_campaign($app);
        check_excludeddomains_in_mobile_app_settings($app);

        check_ispi2_in_context_on_site_campaign($app);
        check_login_in_context_on_site_campaign($app);
        check_productid_in_context_on_site_campaign($app);
        check_pagecaption_in_context_on_site_campaign($app);

        check_blockmodel_in_context_on_site_campaign($app);
        check_blockmodel_in_mobile_app_settings($app);
        check_blockmodel_in_video_an_site($app);

    }
);

sub check_excludeddomains_in_context_on_site_campaign {
    my ($app) = @_;

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        my @excludeddomains = split(/,/, $data->{0}{'excludeddomains'});

        cmp_bag(
            \@excludeddomains,
            [
                qw(
                  showmethemoney.ru
                  showmeyourmoney.ru
                  7123.phone
                  123.phone
                  design.ru
                  rambler.ru
                  xn--80aswg.xn--p1ai
                  )
            ],
            'Got expected excludeddomains (campaign excluded + global excluded)',
        );

        return 1;
    };

    _call_update_in_bk($app, 'context_on_site_campaign', 142898);
}

sub check_excludeddomains_in_search_on_site_campaign {
    my ($app) = @_;

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        my @excludeddomains = split(/,/, $data->{0}{'excludeddomains'});

        cmp_bag(
            \@excludeddomains,
            [
                qw(
                  showmethemoney.ru
                  7123.phone
                  123.phone
                  design.ru
                  rambler.ru
                  xn--80aswg.xn--p1ai
                  approvedmirror.ru
                  )
            ],
            'Got expected excludeddomains (campaign excluded + global excluded)',
        );

        return 1;
    };

    _call_update_in_bk($app, 'search_on_site_campaign', 111161);
}

sub check_excludeddomains_in_mobile_app_settings {
    my ($app) = @_;

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        my @excludeddomains = split(/,/, $data->{0}{'excludeddomains'});

        cmp_bag(
            \@excludeddomains,
            [
                qw(
                  74957397000.phone
                  twitter.com
                  89876543211.phone
                  excludeddomain.mob
                  )
            ],
            'Got expected excludeddomains (campaign excluded + global excluded)',
        );

        return 1;
    };

    _call_update_in_bk($app, 'mobile_app_settings', 43569);
}

sub check_ispi2_in_context_on_site_campaign {
    my ($app) = @_;

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        is($data->{0}{'isPi2'}, 1, 'isPi2',);

        return 1;
    };

    _call_update_in_bk($app, 'context_on_site_campaign', 142898);
}

sub check_login_in_context_on_site_campaign {
    my ($app) = @_;

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        is($data->{0}{'Login'}, 'mocked-yan-partner', 'Login',);

        return 1;
    };

    _call_update_in_bk($app, 'context_on_site_campaign', 142898);
}

sub check_productid_in_context_on_site_campaign {
    my ($app) = @_;

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        is($data->{0}{'ProductID'}, 'context_on_site_campaign', 'ProductID',);

        return 1;
    };

    _call_update_in_bk($app, 'context_on_site_campaign', 142898);
}

sub check_pagecaption_in_context_on_site_campaign {
    my ($app) = @_;

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        is($data->{0}{'PageCaption'}, 'Caption', 'PageCaption',);

        return 1;
    };

    _call_update_in_bk($app, 'context_on_site_campaign', 142898);
}

sub check_blockmodel_in_context_on_site_campaign {
    my ($app) = @_;

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        my $part_of_edit_page_data = {
            DirectBlocks => {2 => {BlockModel => $data->{0}->{DirectBlocks}->{2}->{BlockModel}}},
            RtbBlocks    => {1 => {BlockModel => $data->{0}->{RtbBlocks}->{1}->{BlockModel}}},
        };

        cmp_deeply(
            $part_of_edit_page_data,
            {
                DirectBlocks => {2 => {BlockModel => 'context_on_site_direct'}},
                RtbBlocks    => {1 => {BlockModel => 'context_on_site_rtb'}},
            },
            'Got expected BlockModel',
        );

        return 1;
    };

    _call_update_in_bk($app, 'context_on_site_campaign', 142898);
}

sub check_blockmodel_in_mobile_app_settings {
    my ($app) = @_;

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        my $part_of_edit_page_data = {RtbBlocks => {1 => {BlockModel => $data->{0}->{RtbBlocks}->{1}->{BlockModel}}},};

        cmp_deeply(
            $part_of_edit_page_data,
            {RtbBlocks => {1 => {BlockModel => 'mobile_app_rtb'}},},
            'Got expected BlockModel',
        );

        return 1;
    };

    _call_update_in_bk($app, 'mobile_app_settings', 43569);
}

sub check_blockmodel_in_video_an_site {
    my ($app) = @_;

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        my $part_of_edit_page_data;

        foreach my $block_id (keys %{$data->{0}->{RtbBlocks}}) {
            $part_of_edit_page_data->{RtbBlocks}->{$block_id} =
              {BlockModel => $data->{0}->{RtbBlocks}->{$block_id}->{BlockModel}};
        }

        cmp_deeply(
            $part_of_edit_page_data,
            {
                RtbBlocks => {
                    1 => {BlockModel => 'video_an_site_inpage',},
                    2 => {BlockModel => 'video_an_site_instream',},
                    3 => {BlockModel => 'video_an_site_fullscreen',},
                },
            },
            'Got expected BlockModel',
        );

        return 1;
    };

    _call_update_in_bk($app, 'video_an_site', 154689);
}

sub _call_update_in_bk {
    my ($app, $accessor, $page_id) = @_;

    $app->$accessor->do_action($page_id, 'set_need_update');
    $app->$accessor->update_in_bk({page_id => $page_id});
}
