#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner::Utils qw(
  get_test_data_and_update_if_needed
  mock_curdate
  );

use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2020-02-18 18:28:12');

        my $data = [
            {
                product_id    => 'test',
                client_id     => 11010,
                banners_count => 9,
                target_type   => 3,
                places        => {},
                rtb_blocks    => {
                    '1' => {
                        "RtbDesign" => {
                            1000 => {
                                name   => "",
                                design => {
                                    blockId     => "R-A-1262-1",
                                    name        => "300x500",
                                    imagesFirst => JSON::XS::false,
                                },
                            },
                        },
                    },
                },
            }
        ];

        my %got = $app->api_bk->_get_bk_data($data);
        my $has = get_test_data_and_update_if_needed("data.json", \%got);

        cmp_deeply(\%got, $has, 'api_http_bk->_get_bk_data');
    },
);
