#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Differences;

use PiConstants qw($PROTOBUF_JAVA_TRANSPORT_TURN_ON_KEY $TRANSPORTS_KVSTORE_KEYS);

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_test_data_path get_test_data_and_update_if_needed);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        # mock rand
        *CORE::GLOBAL::rand = sub {66};

        my @kv_sore_keys_to_clear =
          ($PROTOBUF_JAVA_TRANSPORT_TURN_ON_KEY, (map {values %$_} values %$TRANSPORTS_KVSTORE_KEYS));

        my $has = from_json readfile(get_test_data_path() . '/data.json');

        my $got = [];
        foreach my $test (@$has) {
            my ($accessor, $page_id, $kv_store, $opts) = @{$test}{qw( accessor page_id kv_store opts)};

            # clear old params
            foreach my $key (@kv_sore_keys_to_clear) {
                $Application::Model::API::Yandex::BK::CHI_CACHE->remove($key)
                  if $Application::Model::API::Yandex::BK::CHI_CACHE;
                $app->kv_store->delete($key);
            }

            # set new params
            foreach my $key (keys %$kv_store) {
                $app->kv_store->set($key, $kv_store->{$key});
            }

            my ($is_send_to_bssoap, $is_send_to_logbroker, $is_send_protobuf) =
              $app->api_bk->get_transports_to_send($accessor, $page_id, [$opts]);

            push @$got,
              {
                %$test,
                curr_page_id_transports => {
                    is_send_to_bssoap    => $is_send_to_bssoap,
                    is_send_to_logbroker => $is_send_to_logbroker,
                    is_send_protobuf     => $is_send_protobuf,
                }
              };
        }

        get_test_data_and_update_if_needed('data.json', $got);

        eq_or_diff($got, $has, 'api_bk->_is_send_to_bssoap_transport', {context => 10});
    },
);
