#!/usr/bin/perl -w

use Test::More;
use Test::Deep;

use qbit;

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_curdate);

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate("2018-10-02 17:11:07");

        $app->api_bk->log(
            {
                'error'  => '',
                'method' => 'EditPage',
                'params' => [
                    {
                        '0' => {
                            'PageID'    => '320995',
                            'RtbBlocks' => {'1' => {'BlockModel' => 'context_on_site_content'}},
                        }
                    }
                ],
                'proxy_url' => 'http://test-host/',
                'response'  => [
                    {
                        '0' => {
                            'Error'    => '1',
                            'ErrorStr' => 'Width and Heigth of PageID=320995 ImpID=1 undefined or null
',
                            'PageID' => '320995'
                        },
                        'BACKEND_HOST' => 'sas1-39002b3a80a7.qloud-c'
                    }
                ],
                'uri' => 'YaBSSOAPContext'
            }
        );

        my $rows = $app->bk_edit_page->get_all(fields => ['*'], filter => {page_id => 320995});
        map {$rows->[0]{$_} = from_json $rows->[0]{$_}} qw/request response/;

        cmp_deeply(
            $rows,
            [
                {
                    'dt'      => '2018-10-02 17:11:07',
                    'error'   => '',
                    'id'      => '1',
                    'login'   => $Test::Partner2::Simple::DEFAULT_LOGIN,
                    'page_id' => '320995',
                    'request' => from_json(
                        '[{"0":{"PageID":"320995","RtbBlocks":{"1":{"BlockModel":"context_on_site_content"}}}}]'),
                    'response' => from_json(
'[{"0":{"Error":"1","PageID":"320995","ErrorStr":"Width and Heigth of PageID=320995 ImpID=1 undefined or null\\n"},"BACKEND_HOST":"sas1-39002b3a80a7.qloud-c"}]'
                    )
                }
            ],
            'check logs'
        );
    }
);
