#!/usr/bin/perl

use qbit;

use Test::Exception;
use Test::More tests => 1 + 6;

use Test::Partner2::Simple;

my %CURRENCIES = (
    EUR => 100152140,
    USD => 100152130,
);

run_tests(
    sub {
        my ($app) = @_;

        my $api = $app->api_balalayka();

        is($api->_get_payoneer_program_id($_), $CURRENCIES{$_}, sprintf('Check %s program', $_))
          foreach keys %CURRENCIES;

        throws_ok {
            $api->_get_payoneer_program_id('RUB');
        }
        'Exception::API::Payoneer', 'Incorrect currency exception';
        is($@->message(), 'Currency is incorrect', 'Incorrect currency message');

        throws_ok {
            $api->set_option('payoneer_program_id', {});
            $api->_get_payoneer_program_id('EUR');
        }
        'Exception::API::Payoneer', 'Incorrect config exception';
        is($@->message(), 'Payoneer program ID is not set for "EUR"', 'Incorrect config message');
    },
    dont_create_database => 1,
);
