#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use PiSecrets;

use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        no warnings 'redefine';
        no strict 'refs';
        my $token = get_secret('restapi-token');

        *{'LWP::UserAgent::request'} = sub {

            my $r = HTTP::Response->new(200);
            $r->request(HTTP::Request->new());
            $r->content(
'{"key_info": {"user": {"email": "yndx-bessarabov@yandex.ru", "login": "yndx-bessarabov", "uid": 155209804, "name": "Pupkin Vasily"}, "hidden": false, "dt": "2015-08-31T13:29:55.611000", "id": "'
                  . $token
                  . '", "name": "Key #1"}, "result": "OK"}');

            return $r;
        };

        my $data = $app->api_cabinet->check_key(
            user_ip => '213.180.219.192',
            key     => $token,
        );

        cmp_deeply(
            $data,
            {
                key_info => {
                    dt     => "2015-08-31T13:29:55.611000",
                    hidden => ignore(),
                    id     => $token,
                    name   => "Key #1",
                    user   => {
                        email => 'yndx-bessarabov@yandex.ru',
                        login => "yndx-bessarabov",
                        name  => "Pupkin Vasily",
                        uid   => 155209804,
                    },
                },
                result => "OK",
            },
        );
    },
);
