#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Differences;
use Test::More;

use Exception::Validator::Errors;
use Test::Partner2::Simple;
use Test::MockObject::Extends;

my $test_data = [
    {
        data => {
            design => {name => 'design #1'},
            site   => 'desktop',
        },
        response => {
            _content => '{"value":"ok"}',
            '_rc'    => '200',
            '_msg'   => 'Ok',
        }
    },
    {
        data => {
            design => {name => 'design #2'},
            site   => 'desktop',
        },
        response => {
            _content => '{"value":"ok"}',
            '_rc'    => '200',
            '_msg'   => 'Ok',
        }
    },
];

run_tests(
    sub {

        my ($app) = @_;

        our $current_test;
        our $cached_result = {};
        no warnings 'redefine';
        no strict 'refs';
        $app->memcached;
        $app->{'memcached'} = Test::MockObject::Extends->new($app->{'memcached'});

        $app->memcached->mock(
            'set',
            sub {
                my ($self, $prefix, $key, $data, $time) = @_;
                my $cached_data = clone $data;
                $cached_data->{cached_result} = TRUE;
                $cached_result->{$key} = $cached_data;
            }
        );

        $app->memcached->mock(
            'get',
            sub {
                my ($self, $prefix, $key) = @_;
                return $cached_result->{$key};
            }
        );

        *{'LWP::UserAgent::request'} = sub {
            my ($self, $request) = @_;
            my $query = $request->uri()->query();

            my $r = HTTP::Response->new($current_test->{response}->{_rc});
            $r->request(HTTP::Request->new());
            $r->content($current_test->{response}->{_content});
            return $r;
        };

        my $api = $app->api_format_system;

        foreach my $test (@$test_data) {
            local $current_test = $test;
            my $result =
              $api->validate(design => $test->{data}->{design}, site => $test->{data}->{site}, role => 'partner');
            eq_or_diff(to_json($result), $test->{response}->{_content});
            ok(!$result->{cached_result}, 'Chack validate new data result is not cached');

            $result =
              $api->validate(design => $test->{data}->{design}, site => $test->{data}->{site}, role => 'partner');
            ok($result->{cached_result}, 'Check validate same data result is cached');

            $result =
              $api->validate(design => $test->{data}->{design}, site => $test->{data}->{site}, role => 'manager');
            ok(!$result->{cached_result}, 'Check validate with different role is not cached');

            $result =
              $api->validate(design => $test->{data}->{design}, site => $test->{data}->{site}, role => 'manager');
            ok($result->{cached_result}, 'Check validate same data result is cached');
        }

    },
    dont_create_database => 1,
);
