use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

run_tests(
    sub {
        my ($app) = @_;

        no warnings 'redefine';
        no strict 'refs';

        *{'LWP::UserAgent::request'} = sub {
            my $r = HTTP::Response->new(200);
            $r->request(HTTP::Request->new());
            $r->content('["pi-rtb01e.yandex.ru", "pi-rtb01f.yandex.ru"]');
            return $r;
        };

        cmp_bag(
            [$app->api_hbf->get_hosts_from_macros('_C_PARTNER_RTB_FRONTENDS_PROD_')],
            ['pi-rtb01e.yandex.ru', 'pi-rtb01f.yandex.ru',],
            'Got expected answer from get_hosts_from_macros()',
        );

        *{'LWP::UserAgent::request'} = sub {
            my $r = HTTP::Response->new(400);
            $r->request(HTTP::Request->new());
            return $r;
        };

        eval {$app->api_hbf->get_hosts_from_macros('NO_SUCH_MACROS'),};

        is(ref($@), 'Exception::HBF::NotFound', 'Got expeced exception for unknown macros');
        is($@->{text}, "Can't get hosts from macros NO_SUCH_MACROS", 'Got expected error text');
    },
);
