use strict;

use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Differences;
use Test::More tests => 10;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        no strict 'refs';
        no warnings 'redefine';

        *{'LWP::UserAgent::request'} = sub {
            my ($mock, $request) = @_;
            my $url = $request->uri;

            my $r = HTTP::Response->new(200);
            $r->request(HTTP::Request->new());

            if (   $url =~ m#/export/export_serptaghits\.cgi\?#
                && $url =~ m#stoptime=\d{14}#
                && $url =~ m#starttime=\d{14}#)
            {
                *{'HTTP::Response::decoded_content'} = sub {
                    return "20130101000000\t129\t48321\t217
20130101000000\t165\t1814351\t55
20130101000000\t2\t1168541\t200
20130101000000\t63\t48080\t93
20130101000000\t129\t159378\t10
#END
";
                  }
            } elsif ($url =~ m#\Q/export/export-tagstat-pages.cgi\E#) {
                *{'HTTP::Response::decoded_content'} = sub {
                    return "2
3
1000
63
90
3806
50144
98
99
3810
109
113
3816
";
                  }
            } elsif ($url =~ m#\Q/export/dsp-api.cgi?func=info\E#) {
                *{'HTTP::Response::decoded_content'} = sub {
                    return
'{"data":[{"DSPID":"1","Status":"0"},{"DSPID":"2","Status":"1"},{"DSPID":"3","Status":"1"},{"DSPID":"4","Status":"1"},{"DSPID":"5","Status":"1"}],"code":0}';
                  }
            } elsif ($url =~ m#/export/dsp-api\.cgi\?# && $url =~ m#dsp_id=\d# && $url =~ m#func=get_dsp#) {
                *{'HTTP::Response::decoded_content'} = sub {
                    return '{"data":[{"DSPID":"4","Status":"1"}],"code":0}';
                  }
            } elsif ($url =~ m#/export/dsp-api\.cgi\?# && $url =~ m#dsp_id=\d# && $url =~ m#func=(?:start|stop)_dsp#) {
                *{'HTTP::Response::decoded_content'} = sub {
                    return '{"code":0}';
                  }
            } elsif ($url =~ m#\Q/export/export-dsppageerror.cgi?\E#
                && $url =~ m#todate=20130731#
                && $url =~ m#fromdate=20130701#
                && $url =~ m#dspid=1#)
            {
                *{'HTTP::Response::decoded_content'} = sub {
                    return "DSPID\tPageID\tUpdateDate\tErrorType\tErrorsSum
100\t10\t20130802\t1\t9
100\t10\t20130802\t2\t3
100\t10\t20130802\t3\t10
100\t10\t20130803\t1\t12
100\t20\t20130802\t1\t1
100\t20\t20130802\t2\t2
";
                  }
            } elsif ($url =~ m#\Q/export/export-dsppageerror.cgi?\E#
                && $url =~ m#todate=20130731#
                && $url =~ m#fromdate=20130701#
                && $url =~ m#dspid=2#)
            {
                *{'HTTP::Response::decoded_content'} = sub {
                    return "DSPID\tPageID\tUpdateDate\tErrorType\tErrorsSum
";
                  }
            }

            return $r;
        };

        $app->set_option(
            api_http_bk => {
                allow_dsp_via_http      => 1,
                allow_dsp_via_logbroker => 0,
                debug                   => 0,
                url                     => 'http://bssoap-test01g.yandex.net/',
            }
        );

        eq_or_diff(
            $app->api_http_bk->get_big_search_page_ids(),
            ['2', '3', '1000', '63', '90', '3806', '50144', '98', '99', '3810', '109', '113', '3816'],
            'get_big_search_page_ids - OK'
        );

        eq_or_diff(
            $app->api_http_bk->get_serp_tag_hits('2013-01-01', '2013-01-01'),
            [
                {
                    'PageID'     => '129',
                    'UpdateTime' => '2013-01-01',
                    'Shows'      => '217',
                    'CLID'       => '48321'
                },
                {
                    'PageID'     => '165',
                    'UpdateTime' => '2013-01-01',
                    'Shows'      => '55',
                    'CLID'       => '1814351'
                },
                {
                    'PageID'     => '2',
                    'UpdateTime' => '2013-01-01',
                    'Shows'      => '200',
                    'CLID'       => '1168541'
                },
                {
                    'PageID'     => '63',
                    'UpdateTime' => '2013-01-01',
                    'Shows'      => '93',
                    'CLID'       => '48080'
                },
                {
                    'PageID'     => '129',
                    'UpdateTime' => '2013-01-01',
                    'Shows'      => '10',
                    'CLID'       => '159378'
                }
            ],
            'get_serp_tag_hits - OK'
        );

        eq_or_diff(
            $app->api_http_bk->get_dsp_info(),
            [
                {
                    'DSPID'  => '1',
                    'Status' => '0'
                },
                {
                    'DSPID'  => '2',
                    'Status' => '1'
                },
                {
                    'DSPID'  => '3',
                    'Status' => '1'
                },
                {
                    'DSPID'  => '4',
                    'Status' => '1'
                },
                {
                    'DSPID'  => '5',
                    'Status' => '1'
                }
            ],
            'get_dsp_info without params - OK'
        );

        eq_or_diff(
            $app->api_http_bk->get_dsp_info(4),
            [
                {
                    'DSPID'  => '4',
                    'Status' => '1'
                }
            ],
            'get_dsp_info with params - OK'
        );

        eq_or_diff($app->api_http_bk->start_dsp(1), {'code' => 0}, 'start_dsp - OK');

        eq_or_diff($app->api_http_bk->stop_dsp(1), {'code' => 0}, 'stop_dsp - OK');

        eq_or_diff(
            $app->api_http_bk->get_dsp_statistics_responses(1, '2013-07-01', '2013-07-31'),
            [
                {
                    'ErrorsSum'  => '9',
                    'PageID'     => '10',
                    'DSPID'      => '100',
                    'ErrorType'  => '1',
                    'UpdateDate' => '2013-08-02'
                },
                {
                    'ErrorsSum'  => '3',
                    'PageID'     => '10',
                    'DSPID'      => '100',
                    'ErrorType'  => '2',
                    'UpdateDate' => '2013-08-02'
                },
                {
                    'ErrorsSum'  => '10',
                    'PageID'     => '10',
                    'DSPID'      => '100',
                    'ErrorType'  => '3',
                    'UpdateDate' => '2013-08-02'
                },
                {
                    'ErrorsSum'  => '12',
                    'PageID'     => '10',
                    'DSPID'      => '100',
                    'ErrorType'  => '1',
                    'UpdateDate' => '2013-08-03'
                },
                {
                    'ErrorsSum'  => '1',
                    'PageID'     => '20',
                    'DSPID'      => '100',
                    'ErrorType'  => '1',
                    'UpdateDate' => '2013-08-02'
                },
                {
                    'ErrorsSum'  => '2',
                    'PageID'     => '20',
                    'DSPID'      => '100',
                    'ErrorType'  => '2',
                    'UpdateDate' => '2013-08-02'
                }
            ],
            'get_dsp_statistics_responses(return result) - OK'
        );

        eq_or_diff($app->api_http_bk->get_dsp_statistics_responses(2, '2013-07-01', '2013-07-31'),
            [], 'get_dsp_statistics_responses(return []) - OK');

        eq_or_diff(t1($app), 1, 'get_dsp_statistics_responses(bad format date) - OK');
    },
    dont_create_database => 1,
    init                 => [qw(api_http_bk)],
);

sub t1 {
    my ($app) = @_;
    my $error;
    try {
        $app->api_http_bk->get_dsp_statistics_responses(2, '20130701', '2013-07-31');
    }
    catch {
        $error = TRUE;
    };
    return $error;
}
