#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Differences;
use Test::Exception;

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);

use PiConstants qw($CONTENT_TYPE);

my $RESOURCE = 'context_on_site_rtb';
my $USER_ID  = 0;
my %PARAMS   = (
    fields   => [qw(id caption)],
    order_by => [['id', 0], ['caption', 1]],
    filter      => {id => 1000},
    page_number => 2,
    page_size   => 100,
    meta        => 'total',
);

my $EXPECTED_PARAMS;

$ENV{TAP_VERSION} = FALSE;    #disable sending mysql connection credits

run_tests(
    sub {
        my ($app) = @_;

        throws_ok {
            $app->api_java_jsonapi->get_all(\%PARAMS);
        }
        qr/Expected "resource"/, 'resource is required';

        throws_ok {
            $app->api_java_jsonapi->get_all(
                {
                    resource => $RESOURCE,
                    %PARAMS
                }
            );
        }
        qr/Expected "user_id"/, 'user_id is required';

        mock_subs(
            {
                'QBit::Application::Model::API::HTTP::call' => sub {
                    my ($self, $method, %opts) = @_;

                    eq_or_diff($method, $RESOURCE,        'check method');
                    eq_or_diff(\%opts,  $EXPECTED_PARAMS, 'check opts');

                    return '[]';
                },
            }
        );

        $EXPECTED_PARAMS = {
            ':headers' => {
                'Accept'       => $CONTENT_TYPE,
                'Content-Type' => $CONTENT_TYPE,
                'PI-User-Id'   => $USER_ID
            },
            'fields[context_on_site_rtb]' => 'caption,id',
            'filter'                      => '{"id":1000}',
            'meta'                        => 'total',
            'page[number]'                => 2,
            'page[size]'                  => 100,
            'sort'                        => 'id,-caption'
        };
        $app->api_java_jsonapi->get_all(
            {
                resource => $RESOURCE,
                user_id  => $USER_ID,
                %PARAMS
            }
        );

        $EXPECTED_PARAMS = {
            ':headers' => {
                'Accept'       => $CONTENT_TYPE,
                'Content-Type' => $CONTENT_TYPE,
                'PI-User-Id'   => $USER_ID
            },
        };
        $app->api_java_jsonapi->get_all(
            {
                resource => $RESOURCE,
                user_id  => $USER_ID,
            }
        );
    },
    init                 => [qw(api_java_jsonapi)],
    dont_create_database => TRUE,
);
