#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Differences;
use Test::Exception;
use Test::More tests => 7;

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

my $METHOD      = '';
my %NORMAL_ARGS = ();

my $data = get_test_data_and_update_if_needed('data.json', undef, raw => 1);

my $nothing = get_test_data_and_update_if_needed('nothing.json', undef, raw => 1);

run_tests(
    sub {
        my ($app) = @_;

        my $api = $app->api_http_maps;

        no warnings 'redefine';
        no strict 'refs';

        my $mocked_response = $data;
        *{'QBit::Application::Model::API::HTTP::call'} = sub {
            my ($self, $method, %opts) = @_;

            eq_or_diff($method, $METHOD, 'check method');
            eq_or_diff(
                \%opts,
                {
                    'lang'         => 'ru_RU',
                    'ms'           => 'pb',
                    'hr'           => 'json',
                    'origin'       => 'pi2backend',
                    'business_oid' => 123,
                },
                'check opts'
            );

            return $mocked_response;
        };
        ok($api->check_business_oid(123)->{result}, 'normal result');
        $mocked_response = $nothing;
        ok(!($api->check_business_oid(123)->{result}), 'empty result');
    },
    init                 => [qw(api_http_maps)],
    mock_maps            => 0,
    dont_create_database => TRUE,
    mocks                => {mock_send_to_graphite => FALSE, mock_maps => FALSE},
);
