#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Differences;
use Test::Exception;
use Test::More tests => 10;

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

my $METHOD        = '';
my @NORMAL_RESULT = (
    {
        business_oid => "1124715036",
        categories   => [
            "Информационный интернет-сайт", "Интернет-маркетинг",
            "IT-компания"
        ],
        name => "Яндекс",
    },
    {
        business_oid => "1270745226",
        categories   => ["Ресторан",],
        name         => "Изя Гриль",
    }
);
my $ONE_ORG_RESULT = [
    {
        business_oid => "1255020977",
        categories   => ["Бизнес-консалтинг"],
        name         => "Майлдберри"
    }
];

my $data = get_test_data_and_update_if_needed('data.json', undef, raw => 1);

my $nothing = get_test_data_and_update_if_needed('nothing.json', undef, raw => 1);

my $one_org_hash = get_test_data_and_update_if_needed('oneorg.json', undef, raw => 1);

run_tests(
    sub {
        my ($app) = @_;

        my $api = $app->api_http_maps;

        no warnings 'redefine';
        no strict 'refs';

        my $mocked_response = $data;
        *{'QBit::Application::Model::API::HTTP::call'} = sub {
            my ($self, $method, %opts) = @_;

            eq_or_diff($method, $METHOD, 'check method');
            eq_or_diff(
                \%opts,
                {
                    'lang'    => 'ru_RU',
                    'ms'      => 'pb',
                    'hr'      => 'json',
                    'll'      => '34.34,23.23',
                    'mode'    => 'reverse',
                    'origin'  => 'pi2backend',
                    'type'    => 'biz',
                    'results' => 1000
                },
                'check opts'
            );

            return $mocked_response;
        };

        eq_or_diff($api->get_companies_by_ll('23.23,34.34', {}), \@NORMAL_RESULT, 'normal result');

        $mocked_response = $nothing;
        eq_or_diff($api->get_companies_by_ll('23.23,34.34', {}), [], 'empty result');

        $mocked_response = $one_org_hash;
        eq_or_diff($api->get_companies_by_ll('23.23,34.34', {}), $ONE_ORG_RESULT, 'one org hash');
    },
    init                 => [qw( api_http_maps )],
    mock_maps            => 0,
    mocks                => {mock_send_to_graphite => FALSE, mock_maps => FALSE},
    dont_create_database => TRUE,
);
