#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Differences;
use Test::More;

use Exception::Validator::Errors;
use Test::Partner2::Simple;

my $test_data = [
    {
        sources  => [2900],
        response => {
            _content => to_json(
                {
                    "first_reqid" => "1538408092439067-628240429152968162200030-sas1-6982-NEWS_API_RECOMMEND_BY_HOST",
                    "items"       => [
                        {
                            "obj" => {
                                "pictures"  => [{"height" => 520, "width" => 920}],
                                "source_id" => 2900
                            }
                        },
                        {
                            "obj" => {
                                "pictures"  => [{"height" => 621, "width" => 920}],
                                "source_id" => 2900
                            }
                        },
                        {
                            "obj" => {
                                "pictures"  => [{"height" => 520, "width" => 920}],
                                "source_id" => 2900
                            }
                        },
                        {
                            "obj" => {
                                "pictures"  => [{"height" => 340, "width" => 920}],
                                "source_id" => 2900
                            }
                        }
                    ],
                    "widget_exp" => "pure_interest"
                }
            ),
            '_rc'  => '200',
            '_msg' => 'Ok',
        }
    },
    {
        sources  => [2900, 2990],
        response => {
            _content => to_json(
                {
                    "first_reqid" => "1538408092439067-628240429152968162200030-sas1-6982-NEWS_API_RECOMMEND_BY_HOST",
                    "items"       => [
                        {
                            "obj" => {
                                "pictures"  => [{"height" => 520, "width" => 920}],
                                "source_id" => 2900
                            }
                        },
                        {
                            "obj" => {
                                "pictures"  => [{"height" => 621, "width" => 920}],
                                "source_id" => 2900
                            }
                        },
                        {
                            "obj" => {
                                "pictures"  => [{"height" => 520, "width" => 920}],
                                "source_id" => 2900
                            }
                        },
                        {
                            "obj" => {
                                "pictures"  => [{"height" => 340, "width" => 920}],
                                "source_id" => 2900
                            }
                        }
                    ],
                    "widget_exp" => "pure_interest"
                }
            ),
            '_rc'  => '200',
            '_msg' => 'Ok',
        }
    },
    {
        sources  => [2990],
        response => {
            '_content' => to_json(
                {
                    "first_reqid" => "1538574344069540-798338193115951375400030-vla1-2068-NEWS_API_RECOMMEND_BY_HOST",
                    "widget_exp"  => "linear_mix_8_2",
                    "items"       => []
                }
            ),
            '_rc'  => '200',
            '_msg' => 'Ok',
        }
    },
    {
        sources  => [2900000, 2990000],
        response => {
            _content => "There is no valid source id",
            _msg     => "Bad request",
            _rc      => 400,
        }
    },
    {
        sources  => [2900, 2990000],
        response => {
            '_content' => 'Bad source_id: 290000,',
            '_rc'      => '400',
            '_msg'     => 'Bad request',
        }
    },
    {
        sources  => [2990000],
        response => {
            _content => "There is no valid source id",
            _msg     => "Bad request",
            _rc      => 400,
        }
    },
];

run_tests(
    sub {

        my ($app) = @_;

        my $api = $app->api_http_news;
        our $current_test;

        no warnings 'redefine';
        no strict 'refs';

        *{'LWP::UserAgent::request'} = sub {
            my ($self, $request) = @_;
            my $query = $request->uri()->query();

            $query =~ s/.*orig&source_id=//g;
            $query =~ s/&need_picture.*//g;
            $query =~ s/&source_id=/,/g;

            my @query_sources = split ',', $query;

            my $r = HTTP::Response->new($current_test->{response}->{_rc});
            $r->request(HTTP::Request->new());
            $r->content($current_test->{response}->{_content});
            return $r;
        };

        foreach my $test (@$test_data) {
            local $current_test = $test;
            $api->check_sources($test->{sources}, {need_picture => 0});
        }

    },
    dont_create_database => 1,
);
