use qbit;

use Test::Differences;
use Test::More;

use Exception::Validator::Errors;
use Test::Partner2::Simple;
use Test::Partner::Utils;

require Application::Model::API::HTTPLogger;

my @test_data = (
    {
        name     => '200 without logging',
        force    => undef,
        date     => '2020-02-02 02:00:00',
        response => {
            '_content' => 'mocked content',
            '_rc'      => 200,
            '_msg'     => 'Ok',
        }
    },
    {
        name     => '500 without logging',
        force    => undef,
        date     => '2020-02-02 02:00:00',
        response => {
            '_content' => 'mocked content',
            '_rc'      => 500,
            '_msg'     => 'Fail',
        }
    },
    {
        name     => '200 with logging same time',
        force    => 1,
        date     => '2020-02-02 02:00:00',
        response => {
            '_content' => 'mocked content',
            '_rc'      => 200,
            '_msg'     => 'Ok',
        }
    },
    {
        name     => '200 with logging add hour',
        force    => 1,
        date     => '2020-02-02 03:00:00',
        response => {
            '_content' => 'mocked content',
            '_rc'      => 200,
            '_msg'     => 'Ok',
        }
    },
);

run_tests(
    sub {

        my ($app) = @_;

        my $api = $app->api_selfservice;

        no warnings 'redefine';
        no strict 'refs';

        *{'QBit::Application::Model::API::HTTP::INFO'} = sub { };

        my $request_data;
        *{'LWP::UserAgent::request'} = sub {
            my ($self, $request) = @_;

            my $r = HTTP::Response->new($request_data->{response}{_rc});
            $r->request($request);
            $r->content($request_data->{response}{_content} . ': ' . $request_data->{name});

            return $r;
        };

        my $log_data;
        *{'Application::Model::API::HTTPLogger::write_log'} = sub {
            my ($self, $filename, $data) = @_;
            $log_data = $data;
        };

        {
            no warnings 'once';
            $Application::Model::API::Yandex::SelfService::skip_log_ok = 1;
        }
        my @result;
        for my $test (@test_data) {
            if (defined $test->{force}) {
                $app->kv_store->set($Application::Model::API::HTTPLogger::STORE_KEY, $test->{force});
            } else {
                $app->kv_store->delete($Application::Model::API::HTTPLogger::STORE_KEY);
            }
            $request_data = $test;
            mock_curdate($test->{date});

            $log_data = undef;
            my $error;
            # скопирован вызов из Application::Model::API::Yandex::SelfService
            try {
                $api->call(
                    'logbroker',
                    ':post'    => 1,
                    ':headers' => {'Content-Type' => 'application/json',},
                    ':content' => to_json(
                        {
                            destination => 'logbroker',
                            endpoint    => 'topic',
                            payload     => [],
                        },
                        canonical => TRUE
                    ),
                );
            }
            catch {
                my ($e) = @_;
                $error = $e->message;
            };

            push @result, {name => $test->{name}, log => $log_data, error => $error};
        }

        my $expected = get_test_data_and_update_if_needed("result.json", \@result);
        eq_or_diff(from_json(to_json(\@result), canonical => TRUE), $expected, 'compare');
    },
    init  => ['api_selfservice'],
    mocks => {mock_selfservice => FALSE},
);
