use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Partner2::Mock qw(mock_subs restore_subs);
use Test::Differences qw(eq_or_diff);
use Test::Exception;

use Test::More;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        restore_subs([qw(LWP::UserAgent::request)]);
        mock_subs(
            {
                'LWP::UserAgent::request' => sub {
                    my ($mock, $request) = @_;
                    my $url = $request->uri;

                    my $r = HTTP::Response->new(200);
                    $r->request(HTTP::Request->new());
                    $r->content(to_json({result => {code => '200', message_id => '<message_id>', msg => ''}}));
                    return $r;
                },
            }
        );

        throws_ok(
            sub {$app->api_sender->status();},
            "Exception::Validation::BadArguments",
            "check required field template"
        );

        throws_ok(
            sub {$app->api_sender->status(template => 'template');},
            "Exception::Validation::BadArguments",
            "check required field message_id"
        );

        throws_ok(
            sub {$app->api_sender->status(message_id => '<message_id>', template => 'template_name');},
            "Exception::Validation::BadArguments",
            "check status without send"
        );

        my $response = $app->api_sender->send(to_email => 'to@me', template => 'template_name', type => 123);
        my $status =
          $app->api_sender->status(message_id => $response->{result}->{message_id}, template => 'template_name');
        is($status->{result}->{code}, '200', 'check response');

        eq_or_diff(
            from_json($app->partner_db->sender_log->get_all()->[0]->{status})->{result}{code},
            '200', 'got expected data in sender_log',
        );
    },
    init           => [qw( api_sender )],
    fill_databases => 0
);
