#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Differences;
use Test::Exception;
use Test::More tests => 5;

use Test::Partner2::Simple;

my @NORMAL_ARGS = ('test_method', 'field' => 'value',);

run_tests(
    sub {
        my ($app) = @_;

        my $api = $app->api_staff;

        no warnings 'redefine';
        no strict 'refs';

        *{'QBit::Application::Model::API::HTTP::call'} = sub {
            my ($self, @data) = @_;

            eq_or_diff(\@data, \@NORMAL_ARGS, 'check args');

            return undef;
        };
        eq_or_diff($api->call(@NORMAL_ARGS), undef, 'undefined result');

        *{'QBit::Application::Model::API::HTTP::call'} = sub {
            return '';
        };
        eq_or_diff($api->call(@NORMAL_ARGS), '', 'empty result');

        *{'QBit::Application::Model::API::HTTP::call'} = sub {
            return '{"result":"OK"}';
        };
        eq_or_diff($api->call(@NORMAL_ARGS), {result => 'OK',}, 'normal call');
    },
    init                 => [qw( api_staff )],
    dont_create_database => TRUE,
);
