#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Differences;
use Test::Exception;
use Test::More tests => 6;

use Test::Partner2::Simple;

my %NORMAL_RESULT = (
    limit  => 50,
    links  => {},
    page   => 1,
    pages  => 1,
    result => [
        {
            login    => 'login_1',
            official => {is_dismissed => 1,},
        },
        {
            login    => 'login_2',
            official => {is_dismissed => 1,},
        },
        {
            login    => 'login_3',
            official => {is_dismissed => 0,},
        },
    ],
    total => 3,
);

my $CHUNK_SIZE = 50;

run_tests(
    sub {
        my ($app) = @_;

        my $api = $app->api_staff;

        no warnings 'redefine';
        no strict 'refs';

        *{'Application::Model::API::Yandex::Staff::persons'} = sub {
            my ($self, %opts) = @_;

            eq_or_diff(
                \%opts,
                {
                    fields => [qw(login official.is_dismissed)],
                    filter => {
                        login                   => [qw(login_1 login_2 login_3)],
                        'official.is_dismissed' => 'true',
                    },
                },
                'check opts'
            );

            return \%NORMAL_RESULT;
        };
        eq_or_diff($api->is_dismissed([qw(login_1 login_2 login_3)]), [qw(login_1 login_2)], 'normal result');

        my $first_call = TRUE;
        *{'Application::Model::API::Yandex::Staff::persons'} = sub {
            my ($self, %opts) = @_;

            eq_or_diff(
                \%opts,
                {
                    fields => [qw(login official.is_dismissed)],
                    filter => {
                        login => [
                            map {"login_$_"}
                              ($first_call ? (0 .. $CHUNK_SIZE - 1) : ($CHUNK_SIZE .. int($CHUNK_SIZE * 1.5)))
                        ],
                        'official.is_dismissed' => 'true',
                    },
                },
                'check opts'
            );

            if ($first_call) {
                $NORMAL_RESULT{result} = [];
            } else {
                $NORMAL_RESULT{result} =
                  [map {+{login => "login_$_", official => {is_dismissed => 1,},}}
                      $CHUNK_SIZE .. int($CHUNK_SIZE * 1.5)];
            }

            $first_call = FALSE;

            return \%NORMAL_RESULT;
        };
        eq_or_diff(
            $api->is_dismissed([map {"login_$_"} 0 .. int($CHUNK_SIZE * 1.5)]),
            [map {"login_$_"} $CHUNK_SIZE .. int($CHUNK_SIZE * 1.5)],
            'long list'
        );
    },
    init                 => [qw( api_staff )],
    dont_create_database => TRUE,
);
