#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Differences;
use Test::Exception;
use Test::More tests => 4;

use Test::Partner2::Simple;

my $METHOD      = 'persons';
my %NORMAL_ARGS = (
    fields => [qw(login official.is_dismissed)],
    filter => {login => [qw(login_1 login_2 login_3)],},
);
my %NORMAL_RESULT = (
    limit  => 50,
    links  => {},
    page   => 1,
    pages  => 1,
    result => [
        {
            login    => 'login_1',
            official => {is_dismissed => 1,},
        },
        {
            login    => 'login_2',
            official => {is_dismissed => 1,},
        },
        {
            login    => 'login_3',
            official => {is_dismissed => 0,},
        },
    ],
    total => 3,
);

run_tests(
    sub {
        my ($app) = @_;

        my $api = $app->api_staff;

        no warnings 'redefine';
        no strict 'refs';

        *{'QBit::Application::Model::API::HTTP::call'} = sub {
            my ($self, $method, %opts) = @_;

            eq_or_diff($method, $METHOD, 'check method');
            eq_or_diff(
                \%opts,
                {
                    _fields => 'login,official.is_dismissed',
                    login   => 'login_1,login_2,login_3',
                },
                'check opts'
            );

            return to_json \%NORMAL_RESULT;
        };
        eq_or_diff($api->persons(%NORMAL_ARGS), \%NORMAL_RESULT, 'normal result');
    },
    init                 => [qw( api_staff )],
    dont_create_database => TRUE,
);
