use strict;

use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use Test::Differences qw(eq_or_diff);

use qbit;
my $ticket = "demo-ok";

run_tests(
    sub {
        my ($app) = @_;
        _mock_call("OK");
        is($app->api_tvm->call_ping, "OK", "ping");

        _mock_call(to_json({demo => {ticket => $ticket}}));
        is($app->api_tvm->get_service_ticket("demo"), $ticket, "get_service_ticket");
    },
    dont_create_database => 1,
    init                 => ['api_tvm'],
);

sub _mock_call {
    my ($data) = @_;

    no warnings 'redefine';
    no warnings 'once';
    no strict 'refs';
    *Application::Model::API::Yandex::TVM::call_command = sub {
        return $data;
    };
}
