use strict;

use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use Test::Differences qw(eq_or_diff);

use qbit;

my $ERROR_MSG = "%d %s\n
Request: POST https://utils-test.partner.yandex.ru/intapi/get_next_page_id
   Content-Length: 11
   Content-Type: application/x-www-form-urlencoded\n   \n   service=pi2\n   \nResponse: %s
Response headers: ";

run_tests(
    sub {
        my ($app) = @_;

        _mock_request(200, to_json({page_id => 12345}));

        is($app->api_utils_partner2->get_next_page_id(), 12345, 'get_next_page_id - OK');

        _check_error($app, 400, 'Bad Request', to_json({error_message => "'service' length must be > 0"}));

        _check_error($app, 500, 'Internal Server Error', 'invalid json');
    },
    dont_create_database => 1,
);

sub _mock_request {
    my ($code, $body) = @_;

    no strict 'refs';
    no warnings 'redefine';

    *{'LWP::UserAgent::request'} = sub {
        my ($mock, $request) = @_;

        my $r = HTTP::Response->new($code);
        $r->request($request);
        $r->content($body);

        return $r;
    };
}

sub _check_error {
    my ($app, $code, $err_msg, $body) = @_;

    _mock_request($code, $body);

    try {
        $app->api_utils_partner2->get_next_page_id();
    }
    catch {
        my $e = shift;

        is(ref($e), 'Exception::API::UtilsPartner2', 'Correctly exception');

        eq_or_diff($e->message, sprintf($ERROR_MSG, $code, $err_msg, $body), 'Correctly message');
    }
    finally {
        ok(shift, 'Exception throws');
    };
}
