use strict;
use warnings FATAL => 'all';

use qbit;
use Test::Partner2::Simple;

use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        # Контрольные примеры от Я.Деньги
        is(
            $app->api_yamoney->_iddoc_hash(
                "Румянцева", "Наталья", "Владимировна", "1098 109056"
            ),
            "bQZEdF3u8xaaIbLv8uus70HSOY0=",
            "_iddoc_hash()"
          );
        is(
            $app->api_yamoney->_iddoc_hash("Васильев", "Николай", "Петрович", "1234 567890"),
            "xXZ8CJEnbwqvWH2R9HlCVPw47KY=",
            "_iddoc_hash()"
          );
        is(
            $app->api_yamoney->_iddoc_hash("Пушкин", "Александр", "Сергеевич", "2345 768758"),
            "F3CMilpKhno6i2mVYz99Bitr444=",
            "_iddoc_hash()"
          );

        # Примеры из тестовых данных
        is(
            $app->api_yamoney->_iddoc_hash("F", "I", "O", "1234 123123"),
            "A357J/yWW+rra2PaJfwLCATYlww=",
            "_iddoc_hash()"
          );
        is(
            $app->api_yamoney->_iddoc_hash(
                "КУРКОВ", "ЛЕОНИД", "КОНСТАНТИНОВИЧ",
                "4005 567656"
            ),
            "6Toe1/usbHuHc4H6vCvdj6Di42s=",
            "_iddoc_hash()"
          );
        is(
            $app->api_yamoney->_iddoc_hash("Милорад", "Спавич", undef, "12345 123"),
            "ds+gLF9ZfvcWEcP4L44+NaNBV9g=",
            "_iddoc_hash()"
          );
        is(
            $app->api_yamoney->_iddoc_hash("FIO1", undef, undef, "1234 5678"),
            "t2v9IvHLhi+rFI4FuXJ0Atw1Xxo=",
            "_iddoc_hash()"
          );
        is(
            $app->api_yamoney->_iddoc_hash(
                "Пфальц-Зульцбахская",
                "Анна Кристина",
                "Луиза", "1098 109056"
            ),
            "FI6FHyASemFEAvZ++EqhSe1HUtU=",
            "_iddoc_hash()"
          );
        is(
            $app->api_yamoney->_iddoc_hash("Оджагов", "Анар", "Ризван Оглы", "1098 109056"),
            "G/YuTqmzJ0h7Xy3EOcA4TMC7bz0=",
            "_iddoc_hash()"
          );
        is(
            $app->api_yamoney->_iddoc_hash("Fedorov", "Ivan", "", "1098 109056"),
            "eho4ywHp1Yc22cG4Flpj83YELvQ=",
            "_iddoc_hash()"
          );
    },
);
