use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        ok($app->api_yamoney->_is_valid_account_number(41001123456740), "Correct account number");

        my @invalid = (
            {
                value     => 'test_string',
                test_name => 'Account number should contain only numbers',
            },
            {
                value     => ('1' x 33),
                test_name => 'Account number should contain not more than 32 symbols',
            },
            {
                value     => ('1' x 10),
                test_name => 'Account number should contain not less than 11 symbols',
            },
            {
                value     => '01001123456788',
                test_name => "0 can't be the first digit",
            },
            {
                value     => '91111111111',
                test_name => 'Length should be more than fist digit + 4',
            },
            {
                value     => '41001123456700',
                test_name => "Last 2 digits can't be zeros",
            },
            {value => "4100112345678901234567890188",},
            {value => -1,},
            {value => 0,},
            {value => undef,},
            {value => [],},
            {value => {},},
            {value => \&die,},
            {value => qr//,},
        );

        foreach my $test (@invalid) {
            ok(
                !$app->api_yamoney->_is_valid_account_number($test->{value}),
                $test->{test_name} // '_is_valid_account_number()'
              );
        }

    },
);
