#!/usr/bin/perl

use qbit;
use Test::Partner2::Simple;

use Test::More;
use Test::Most qw();
use Test::Deep qw(cmp_deeply);

no warnings 'redefine';
no strict 'refs';

my $SIGNED_OR_FAXED =
    "product                  | 1 | 2 | 3 | 4 | 5 | 6 | 7 |\n"
  . "context_on_site_content  |   |   |   |   |   |   |   |\n"
  . "context_on_site_direct   |   |   |   |   |   |   |   |\n"
  . "context_on_site_natural  |   |   |   |   |   |   |   |\n"
  . "context_on_site_rtb      |   |   |   |   |   |   |   |\n"
  . "context_on_site_stripe   |   |   |   |   |   |   |   |\n"
  . "mobile_app_rtb           |   |   |   |   |   |   |   |\n"
  . "search_on_site_direct    |   |   |   |   | x |   |   |\n"
  . "search_on_site_market    |   |   |   |   |   |   |   |\n"
  . "search_on_site_mcb       |   |   |   |   |   |   |   |\n"
  . "search_on_site_premium   |   |   |   |   |   |   |   |\n"
  . "video_an_site_instream   |   |   |   |   |   |   |   |\n"
  . "video_an_site_inpage     |   |   |   |   |   |   |   |\n"
  . "video_an_site_fullscreen |   |   |   |   |   |   |   |\n"
  . "context_on_site_adblock  |   |   |   |   |   |   |   |\n"
  . "indoor_block             |   |   |   |   |   |   |   |\n"
  . "outdoor_block            |   |   |   |   |   |   |   |\n";

my $SIGNED = $SIGNED_OR_FAXED;
$SIGNED =~ s/\| x \|/| s |/;

sub must_be_signed_or_faxed__and_signed {
    my ($app) = @_;

    local *{'Application::Model::AgreementChecker::_Agreement::_get_today'} = sub {
        return '2014-01-16';
    };

    local *{'Application::Model::AgreementChecker::_Agreement::_get_rules_table'} = sub {
        return $SIGNED_OR_FAXED;
    };

    local *{'Application::Model::API::Yandex::Balance::get_partner_contracts'} = sub {
        return [
            {
                Contract => {
                    type          => 'PARTNERS',
                    dt            => '2000-01-01',
                    is_signed     => '2000-01-01',
                    contract_type => 5,
                },
                Collaterals => [],
            }
        ];
    };

    my $data = $app->agreement_checker->get_data_for_client_id(client_id => 123,);

    cmp_deeply(
        $data,
        {
            today    => {'search_on_site_direct' => 1,},
            tomorrow => {'search_on_site_direct' => 1,}
        },
        'get_data_for_client_id()',
    );
}

sub must_be_signed_or_faxed__and_faxed {
    my ($app) = @_;

    local *{'Application::Model::AgreementChecker::_Agreement::_get_today'} = sub {
        return '2014-01-16';
    };

    local *{'Application::Model::AgreementChecker::_Agreement::_get_rules_table'} = sub {
        return $SIGNED_OR_FAXED;
    };

    local *{'Application::Model::API::Yandex::Balance::get_partner_contracts'} = sub {
        return [
            {
                Contract => {
                    type          => 'PARTNERS',
                    dt            => '2000-01-01',
                    is_faxed      => '2000-01-01',
                    contract_type => 5,
                },
                Collaterals => [],
            }
        ];
    };

    my $data = $app->agreement_checker->get_data_for_client_id(client_id => 123,);

    cmp_deeply(
        $data,
        {
            today    => {'search_on_site_direct' => 1,},
            tomorrow => {'search_on_site_direct' => 1,}
        },
        'get_data_for_client_id()',
    );
}

sub must_be_signed_or_faxed__and_nothing {
    my ($app) = @_;

    local *{'Application::Model::AgreementChecker::_Agreement::_get_today'} = sub {
        return '2014-01-16';
    };

    local *{'Application::Model::AgreementChecker::_Agreement::_get_rules_table'} = sub {
        return $SIGNED_OR_FAXED;
    };

    local *{'Application::Model::API::Yandex::Balance::get_partner_contracts'} = sub {
        return [
            {
                Contract => {
                    type          => 'PARTNERS',
                    dt            => '2000-01-01',
                    contract_type => 5,
                },
                Collaterals => [],
            }
        ];
    };

    my $data = $app->agreement_checker->get_data_for_client_id(client_id => 123,);

    cmp_deeply($data, {}, 'get_data_for_client_id()',);
}

sub must_be_signed__and_signed {
    my ($app) = @_;

    local *{'Application::Model::AgreementChecker::_Agreement::_get_today'} = sub {
        return '2014-01-16';
    };

    local *{'Application::Model::AgreementChecker::_Agreement::_get_rules_table'} = sub {
        return $SIGNED;
    };

    local *{'Application::Model::API::Yandex::Balance::get_partner_contracts'} = sub {
        return [
            {
                Contract => {
                    type          => 'PARTNERS',
                    dt            => '2000-01-01',
                    is_signed     => '2000-01-01',
                    contract_type => 5,
                },
                Collaterals => [],
            }
        ];
    };

    my $data = $app->agreement_checker->get_data_for_client_id(client_id => 123,);

    cmp_deeply(
        $data,
        {
            today    => {'search_on_site_direct' => 1,},
            tomorrow => {'search_on_site_direct' => 1,}
        },
        'get_data_for_client_id()',
    );
}

sub must_be_signed__and_noting {
    my ($app) = @_;

    local *{'Application::Model::AgreementChecker::_Agreement::_get_today'} = sub {
        return '2014-01-16';
    };

    local *{'Application::Model::AgreementChecker::_Agreement::_get_rules_table'} = sub {
        return $SIGNED;
    };

    local *{'Application::Model::API::Yandex::Balance::get_partner_contracts'} = sub {
        return [
            {
                Contract => {
                    type          => 'PARTNERS',
                    dt            => '2000-01-01',
                    contract_type => 5,
                },
                Collaterals => [],
            }
        ];
    };

    my $data = $app->agreement_checker->get_data_for_client_id(client_id => 123,);

    cmp_deeply($data, {}, 'get_data_for_client_id()',);
}

sub must_be_signed__and_faxed {
    my ($app) = @_;

    local *{'Application::Model::AgreementChecker::_Agreement::_get_today'} = sub {
        return '2014-01-16';
    };

    local *{'Application::Model::AgreementChecker::_Agreement::_get_rules_table'} = sub {
        return $SIGNED;
    };

    local *{'Application::Model::API::Yandex::Balance::get_partner_contracts'} = sub {
        return [
            {
                Contract => {
                    type          => 'PARTNERS',
                    dt            => '2000-01-01',
                    is_faxed      => '2000-01-01',
                    contract_type => 5,
                },
                Collaterals => [],
            }
        ];
    };

    my $data = $app->agreement_checker->get_data_for_client_id(client_id => 123,);

    cmp_deeply($data, {}, 'get_data_for_client_id()',);
}

run_tests(
    sub {
        my ($app) = @_;

        local *{'Application::Model::AgreementCheckerMock::get_data_for_client_id'} = sub {
            return Application::Model::AgreementChecker::get_data_for_client_id(@_);
        };

        must_be_signed_or_faxed__and_signed($app);
        must_be_signed_or_faxed__and_faxed($app);
        must_be_signed_or_faxed__and_nothing($app);
        must_be_signed__and_signed($app);
        must_be_signed__and_faxed($app);
        must_be_signed__and_noting($app);
    },
    fill_databases => 0,
    init           => [qw(agreement_checker)]
);
