use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::More;
use Test::Deep;

use PiConstants qw($ADINSIDE_CLIENT_ID);

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2016-07-07 16:30:04');

        my $data_11024 = $app->agreement_checker->get_data_for_client_id(client_id => 11024);

        cmp_deeply($data_11024, {}, 'tubby-partner',);

        my $data_11025 = $app->agreement_checker->get_data_for_client_id(client_id => 11025);

        cmp_deeply(
            $data_11025,
            {
                today => {
                    context_on_site_content => 1,
                    context_on_site_direct  => 1,
                    context_on_site_rtb     => 1,
                    mobile_app_rtb          => 1,
                    search_on_site_direct   => 1,
                    search_on_site_premium  => 1,
                    video_an_site_instream  => 1,
                    video_an_site_inpage    => 1,
                },
                tomorrow => {
                    context_on_site_content => 1,
                    context_on_site_direct  => 1,
                    context_on_site_rtb     => 1,
                    mobile_app_rtb          => 1,
                    search_on_site_direct   => 1,
                    search_on_site_premium  => 1,
                    video_an_site_instream  => 1,
                    video_an_site_inpage    => 1,
                },
            },
            'tubby-partner-with-agreement',
        );

        no strict 'refs';
        no warnings 'redefine';
        local *{'QBit::Application::Model::API::Yandex::Balance::get_partner_contracts'} = sub {
            return [
                {
                    Client => {
                        agency_id              => "",
                        aux_is_docs_detailed   => 0,
                        aux_is_docs_separated  => 0,
                        budget                 => 29118.47,
                        city                   => "hidden",
                        class_id               => 302354,
                        client_type_id         => 0,
                        creation_dt            => "2004-08-26",
                        currency_payment       => "",
                        deny_cc                => 0,
                        direct25               => 0,
                        domain_check_comment   => "Заявка 140220-0718",
                        domain_check_status    => 1,
                        dt                     => "2015-09-07",
                        email                  => "hidden",
                        fax                    => "",
                        fullname               => "",
                        full_repayment         => 1,
                        id                     => 302354,
                        internal               => 0,
                        is_agency              => 0,
                        is_non_resident        => 0,
                        is_wholesaler          => "",
                        manual_discount        => 0,
                        manual_suspect         => 0,
                        manual_suspect_comment => "",
                        name                   => "hidden",
                        overdraft_ban          => 0,
                        overdraft_limit        => 0,
                        partner_type           => 1,
                        phone                  => "hidden",
                        region_id              => 225,
                        reliable_cc_payer      => 0,
                        subregion_id           => 11316,
                        suspect                => 1,
                        url                    => "",
                    },
                    Collaterals => [
                        {
                            class              => "ANNOUNCEMENT",
                            collateral_type_id => 2090,
                            contract2_id       => 53408,
                            create_dt          => "2012-12-31",
                            dt                 => "2012-12-31",
                            end_dt             => "2012-12-31",
                            end_reason         => 2,
                            id                 => 86756,
                            is_cancelled       => "",
                            is_faxed           => "",
                            is_signed          => "2012-12-24",
                            memo               => "hidden",
                            num                => "У",
                            sent_dt            => "",
                            update_dt          => "2015-04-02",
                        },
                    ],
                    Contract => {
                        agregator_pct      => "",
                        client_id          => 302354,
                        collateral_type_id => "",
                        contract_type      => 1,
                        contract2_id       => 53408,
                        create_dt          => "2009-03-01",
                        currency           => 643,
                        doc_set            => 3,
                        dt                 => "2009-03-01",
                        end_dt             => "",
                        external_id        => "РС-3794-03/09",
                        firm               => 1,
                        id                 => 36275,
                        is_cancelled       => "",
                        is_faxed           => "",
                        is_signed          => "2010-06-29",
                        manager_code       => 20468,
                        market_api_pct     => 50,
                        nds                => 0,
                        num                => "",
                        partner_pct        => 45,
                        payment_type       => 1,
                        pay_to             => 1,
                        person_id          => 329639,
                        type               => "PARTNERS",
                        update_dt          => "2015-04-02",
                    },
                    Person => {
                        account                => 40802800000000000001,
                        address                => "hidden",
                        address_postcode       => 630099,
                        address_updated        => "",
                        authority_doc_details  => "hidden",
                        authority_doc_type     => "hidden",
                        bank_type              => 2,
                        ben_account            => "",
                        ben_bank               => "",
                        bik                    => '045005780',
                        birthday               => "",
                        birthplace_country     => "",
                        birthplace_district    => "",
                        birthplace_region      => "",
                        city                   => "hidden",
                        client_id              => 302354,
                        delivery_city          => "",
                        delivery_type          => 0,
                        dt                     => "2012-10-18",
                        email                  => "hidden",
                        fax                    => "",
                        fias_guid              => "hidden",
                        fname                  => "hidden",
                        hidden                 => 0,
                        iban                   => "",
                        id                     => 329639,
                        iik                    => "",
                        inn                    => 100,
                        inn_doc_details        => "",
                        invalid_address        => 0,
                        invalid_bankprops      => "",
                        is_partner             => 1,
                        _kladr_code            => 100,
                        kpp                    => "",
                        kz_in                  => "",
                        legal_address_postcode => "",
                        legaladdress           => "hidden",
                        live_signature         => 0,
                        lname                  => "hidden",
                        longname               => "hidden",
                        memo                   => "",
                        mname                  => "hidden",
                        name                   => "hidden",
                        ogrn                   => "",
                        other                  => "",
                        passport_code          => "",
                        passport_d             => "",
                        passport_e             => "",
                        passport_n             => "",
                        passport_s             => "",
                        person_account         => "",
                        pfr                    => "",
                        phone                  => "hidden",
                        postaddress            => "",
                        postaddress_envelope   => "hidden",
                        postcode               => 630099,
                        postsuffix             => "hidden",
                        region                 => 65,
                        representative         => "hidden",
                        revise_act_period_type => "",
                        rnn                    => "",
                        signer_person_gender   => "",
                        signer_person_name     => "hidden",
                        signer_position_name   => "",
                        street                 => "",
                        swift                  => "",
                        tax_type               => "",
                        type                   => "ur",
                        us_state               => "",
                        vat_payer              => "",
                        yamoney_wallet         => "",
                    },
                },
                {
                    Client => {
                        agency_id              => "",
                        aux_is_docs_detailed   => 0,
                        aux_is_docs_separated  => 0,
                        budget                 => 29118.47,
                        city                   => "hidden",
                        class_id               => 302354,
                        client_type_id         => 0,
                        creation_dt            => "2004-08-26",
                        currency_payment       => "",
                        deny_cc                => 0,
                        direct25               => 0,
                        domain_check_comment   => "hidden",
                        domain_check_status    => 1,
                        dt                     => "2015-09-07",
                        email                  => "hidden",
                        fax                    => "",
                        fullname               => "",
                        full_repayment         => 1,
                        id                     => 302354,
                        internal               => 0,
                        is_agency              => 0,
                        is_non_resident        => 0,
                        is_wholesaler          => "",
                        manual_discount        => 0,
                        manual_suspect         => 0,
                        manual_suspect_comment => "",
                        name                   => "hidden",
                        overdraft_ban          => 0,
                        overdraft_limit        => 0,
                        partner_type           => 1,
                        phone                  => "hidden",
                        region_id              => 225,
                        reliable_cc_payer      => 0,
                        subregion_id           => 11316,
                        suspect                => 1,
                        url                    => "",
                    },
                    Collaterals => [],
                    Contract    => {
                        agregator_pct      => "",
                        client_id          => 302354,
                        collateral_type_id => "",
                        contract_type      => 1,
                        contract2_id       => 53289,
                        create_dt          => "2008-12-30",
                        currency           => 643,
                        doc_set            => 3,
                        dt                 => "2008-12-30",
                        end_dt             => "2009-02-28",
                        external_id        => "РС-3677-12/08",
                        firm               => 1,
                        id                 => 36154,
                        is_cancelled       => "",
                        is_faxed           => "2010-06-29",
                        is_signed          => "2010-06-29",
                        manager_code       => 20468,
                        nds                => 18,
                        num                => "",
                        partner_pct        => 45,
                        payment_type       => 1,
                        person_id          => 320157,
                        type               => "PARTNERS",
                        update_dt          => "2015-04-02",
                    },
                    Person => {
                        account                => 40802800000000000001,
                        address                => "hidden",
                        address_postcode       => "",
                        address_updated        => "",
                        authority_doc_details  => "hidden",
                        authority_doc_type     => "",
                        bank_type              => 2,
                        ben_account            => "",
                        ben_bank               => "",
                        bik                    => 100,
                        birthday               => "",
                        birthplace_country     => "",
                        birthplace_district    => "",
                        birthplace_region      => "",
                        city                   => "hidden",
                        client_id              => 302354,
                        delivery_city          => "",
                        delivery_type          => 0,
                        dt                     => "2012-08-24",
                        email                  => "hidden",
                        fax                    => "",
                        fias_guid              => "",
                        fname                  => "hidden",
                        hidden                 => 0,
                        iban                   => "",
                        id                     => 320157,
                        iik                    => "",
                        inn                    => 100,
                        inn_doc_details        => "",
                        invalid_address        => 0,
                        invalid_bankprops      => "",
                        is_partner             => 1,
                        _kladr_code            => "",
                        kpp                    => 100,
                        kz_in                  => "",
                        legal_address_postcode => "",
                        legaladdress           => "hidden",
                        live_signature         => 0,
                        lname                  => "hidden",
                        longname               => "hidden",
                        memo                   => "",
                        mname                  => "hidden",
                        name                   => "hidden",
                        ogrn                   => "",
                        other                  => "",
                        passport_code          => "",
                        passport_d             => "",
                        passport_e             => "",
                        passport_n             => "",
                        passport_s             => "",
                        person_account         => "",
                        pfr                    => "",
                        phone                  => 100,
                        postaddress            => "hidden",
                        postaddress_envelope   => "hidden",
                        postcode               => 630099,
                        postsuffix             => "",
                        region                 => 65,
                        representative         => "hidden",
                        revise_act_period_type => "",
                        rnn                    => "",
                        signer_person_gender   => "",
                        signer_person_name     => "hidden",
                        signer_position_name   => "hidden",
                        street                 => "",
                        swift                  => "",
                        tax_type               => "",
                        type                   => "ur",
                        us_state               => "",
                        vat_payer              => "",
                        yamoney_wallet         => "",
                    },
                },
                {
                    Client => {
                        agency_id              => "",
                        aux_is_docs_detailed   => 0,
                        aux_is_docs_separated  => 0,
                        budget                 => 29118.47,
                        city                   => "hidden",
                        class_id               => 302354,
                        client_type_id         => 0,
                        creation_dt            => "2004-08-26",
                        currency_payment       => "",
                        deny_cc                => 0,
                        direct25               => 0,
                        domain_check_comment   => "hidden",
                        domain_check_status    => 1,
                        dt                     => "2015-09-07",
                        email                  => "hidden",
                        fax                    => "",
                        fullname               => "",
                        full_repayment         => 1,
                        id                     => 302354,
                        internal               => 0,
                        is_agency              => 0,
                        is_non_resident        => 0,
                        is_wholesaler          => "",
                        manual_discount        => 0,
                        manual_suspect         => 0,
                        manual_suspect_comment => "",
                        name                   => "hidden",
                        overdraft_ban          => 0,
                        overdraft_limit        => 0,
                        partner_type           => 1,
                        phone                  => "hidden",
                        region_id              => 225,
                        reliable_cc_payer      => 0,
                        subregion_id           => 11316,
                        suspect                => 1,
                        url                    => "",
                    },
                    Collaterals => [
                        {
                            class              => "COLLATERAL",
                            collateral_type_id => 2020,
                            contract2_id       => 73696,
                            create_dt          => "2014-01-01",
                            dt                 => "2014-01-01",
                            id                 => 102372,
                            is_cancelled       => "",
                            is_faxed           => "",
                            is_signed          => "2014-01-01",
                            memo               => "hidden",
                            num                => "Ф-1",
                            partner_pct        => 43,
                            update_dt          => "2015-04-02",
                        },
                    ],
                    Contract => {
                        client_id          => 302354,
                        collateral_type_id => "",
                        contract_type      => 5,
                        contract2_id       => 73696,
                        create_dt          => "2013-01-01",
                        currency           => 643,
                        doc_set            => 4,
                        dt                 => "2013-01-01",
                        end_dt             => "",
                        external_id        => "РСЯ-12981-01/13",
                        firm               => 1,
                        id                 => 86757,
                        is_cancelled       => "",
                        is_faxed           => "2013-01-11",
                        is_signed          => "2013-02-21",
                        manager_code       => 20162,
                        market_api_pct     => 50,
                        market_banner      => 0,
                        memo               => "hidden",
                        nds                => 18,
                        num                => "",
                        open_date          => 0,
                        partner_pct        => 45,
                        payment_type       => 1,
                        pay_to             => 1,
                        person_id          => 916549,
                        search_forms       => 0,
                        sent_dt            => "",
                        type               => "PARTNERS",
                        update_dt          => "2015-04-02",
                    },
                    Person => {
                        account                => 40802800000000000001,
                        address                => "hidden",
                        address_postcode       => "",
                        address_updated        => "",
                        authority_doc_details  => "",
                        authority_doc_type     => "hidden",
                        bank_type              => 0,
                        ben_account            => "",
                        ben_bank               => "",
                        bik                    => 100,
                        birthday               => "",
                        birthplace_country     => "",
                        birthplace_district    => "",
                        birthplace_region      => "",
                        city                   => "hidden",
                        client_id              => 302354,
                        delivery_city          => "",
                        delivery_type          => 0,
                        dt                     => "2015-11-18",
                        email                  => "hidden",
                        fax                    => "",
                        fias_guid              => "hidden",
                        fname                  => "hidden",
                        hidden                 => 0,
                        iban                   => "",
                        id                     => 916549,
                        iik                    => "",
                        inn                    => 100,
                        inn_doc_details        => "",
                        invalid_address        => 0,
                        invalid_bankprops      => "",
                        is_partner             => 1,
                        _kladr_code            => 540000010000729,
                        kpp                    => 100,
                        kz_in                  => "",
                        legal_address_postcode => "",
                        legaladdress           => "hidden",
                        live_signature         => 0,
                        lname                  => "hidden",
                        longname               => "hidden",
                        memo                   => "",
                        mname                  => "hidden",
                        name                   => "hidden",
                        ogrn                   => "",
                        other                  => "",
                        passport_code          => "",
                        passport_d             => "",
                        passport_e             => "",
                        passport_n             => "",
                        passport_s             => "",
                        person_account         => "",
                        pfr                    => "",
                        phone                  => "hidden",
                        postaddress            => "",
                        postaddress_envelope   => "hidden",
                        postcode               => 630099,
                        postsuffix             => "д 12",
                        region                 => "",
                        representative         => "hidden",
                        revise_act_period_type => "",
                        rnn                    => "",
                        signer_person_gender   => "",
                        signer_person_name     => "hidden",
                        signer_position_name   => "hidden",
                        street                 => "hidden",
                        swift                  => "",
                        tax_type               => "",
                        type                   => "ur",
                        us_state               => "",
                        vat_payer              => "",
                        yamoney_wallet         => "",
                    },
                },
                {
                    Client => {
                        agency_id              => "",
                        aux_is_docs_detailed   => 0,
                        aux_is_docs_separated  => 0,
                        budget                 => 29118.47,
                        city                   => "hidden",
                        class_id               => 302354,
                        client_type_id         => 0,
                        creation_dt            => "2004-08-26",
                        currency_payment       => "",
                        deny_cc                => 0,
                        direct25               => 0,
                        domain_check_comment   => "hidden",
                        domain_check_status    => 1,
                        dt                     => "2015-09-07",
                        email                  => "hidden",
                        fax                    => "",
                        fullname               => "",
                        full_repayment         => 1,
                        id                     => 302354,
                        internal               => 0,
                        is_agency              => 0,
                        is_non_resident        => 0,
                        is_wholesaler          => "",
                        manual_discount        => 0,
                        manual_suspect         => 0,
                        manual_suspect_comment => "",
                        name                   => "hidden",
                        overdraft_ban          => 0,
                        overdraft_limit        => 0,
                        partner_type           => 1,
                        phone                  => "hidden",
                        region_id              => 225,
                        reliable_cc_payer      => 0,
                        subregion_id           => 11316,
                        suspect                => 1,
                        url                    => "",
                    },
                    Collaterals => [],
                    Contract    => {
                        client_id          => 302354,
                        collateral_type_id => "",
                        contract_type      => 6,
                        contract2_id       => 357491,
                        create_dt          => "2016-06-01",
                        currency           => 643,
                        doc_set            => 4,
                        dt                 => "2016-06-01",
                        external_id        => "РС-50494-06/16",
                        firm               => 1,
                        id                 => 286087,
                        is_cancelled       => "",
                        is_faxed           => "",
                        is_signed          => "",
                        manager_code       => 20468,
                        market_api_pct     => 50,
                        market_banner      => 0,
                        memo               => "hidden",
                        nds                => 18,
                        num                => "",
                        open_date          => 1,
                        partner_pct        => 43,
                        payment_type       => 1,
                        pay_to             => 1,
                        person_id          => 916549,
                        search_forms       => 0,
                        type               => "PARTNERS",
                        update_dt          => "2016-06-01",
                    },
                    Person => {
                        account                => 40802800000000000001,
                        address                => "hidden",
                        address_postcode       => "",
                        address_updated        => "",
                        authority_doc_details  => "",
                        authority_doc_type     => "hidden",
                        bank_type              => 0,
                        ben_account            => "",
                        ben_bank               => "",
                        bik                    => 100,
                        birthday               => "",
                        birthplace_country     => "",
                        birthplace_district    => "",
                        birthplace_region      => "",
                        city                   => "hidden",
                        client_id              => 302354,
                        delivery_city          => "",
                        delivery_type          => 0,
                        dt                     => "2015-11-18",
                        email                  => "hidden",
                        fax                    => "",
                        fias_guid              => "hidden",
                        fname                  => "hidden",
                        hidden                 => 0,
                        iban                   => "",
                        id                     => 916549,
                        iik                    => "",
                        inn                    => 5407466838,
                        inn_doc_details        => "",
                        invalid_address        => 0,
                        invalid_bankprops      => "",
                        is_partner             => 1,
                        _kladr_code            => 540000010000729,
                        kpp                    => 540701001,
                        kz_in                  => "",
                        legal_address_postcode => "",
                        legaladdress           => "hidden",
                        live_signature         => 0,
                        lname                  => "hidden",
                        longname               => "hidden",
                        memo                   => "",
                        mname                  => "hidden",
                        name                   => "hidden",
                        ogrn                   => "",
                        other                  => "",
                        passport_code          => "",
                        passport_d             => "",
                        passport_e             => "",
                        passport_n             => "",
                        passport_s             => "",
                        person_account         => "",
                        pfr                    => "",
                        phone                  => "hidden",
                        postaddress            => "",
                        postaddress_envelope   => "hidden",
                        postcode               => 630099,
                        postsuffix             => "hidden",
                        region                 => "",
                        representative         => "hidden",
                        revise_act_period_type => "",
                        rnn                    => "",
                        signer_person_gender   => "",
                        signer_person_name     => "hidden",
                        signer_position_name   => "hidden",
                        street                 => "hidden",
                        swift                  => "",
                        tax_type               => "",
                        type                   => "ur",
                        us_state               => "",
                        vat_payer              => "",
                        yamoney_wallet         => "",
                    },
                },
                {
                    Client => {
                        agency_id              => "",
                        aux_is_docs_detailed   => 0,
                        aux_is_docs_separated  => 0,
                        budget                 => 29118.47,
                        city                   => "hidden",
                        class_id               => 302354,
                        client_type_id         => 0,
                        creation_dt            => "2004-08-26",
                        currency_payment       => "",
                        deny_cc                => 0,
                        direct25               => 0,
                        domain_check_comment   => "hidden",
                        domain_check_status    => 1,
                        dt                     => "2015-09-07",
                        email                  => "hidden",
                        fax                    => "",
                        fullname               => "",
                        full_repayment         => 1,
                        id                     => 302354,
                        internal               => 0,
                        is_agency              => 0,
                        is_non_resident        => 0,
                        is_wholesaler          => "",
                        manual_discount        => 0,
                        manual_suspect         => 0,
                        manual_suspect_comment => "",
                        name                   => "hidden",
                        overdraft_ban          => 0,
                        overdraft_limit        => 0,
                        partner_type           => 1,
                        phone                  => "hidden",
                        region_id              => 225,
                        reliable_cc_payer      => 0,
                        subregion_id           => 11316,
                        suspect                => 1,
                        url                    => "",
                    },
                    Collaterals => [],
                    Contract    => {
                        atypical_conditions => 0,
                        bank_details_id     => "",
                        brand_clients       => {
                            302354  => 1,
                            7123655 => 1,
                        },
                        brand_type           => 7,
                        client_id            => 302354,
                        collateral_type_id   => "",
                        commission           => 50,
                        contract2_id         => 205636,
                        create_dt            => "2015-04-04",
                        currency             => "",
                        discount_policy_type => "",
                        dt                   => "2015-04-04",
                        external_id          => "34544/15",
                        finish_dt            => "",
                        firm                 => 1,
                        id                   => 153873,
                        is_booked            => 0,
                        is_cancelled         => "",
                        is_faxed             => "",
                        is_signed            => "2015-04-02",
                        manager_bo_code      => "",
                        manager_code         => "",
                        memo                 => "hidden",
                        num                  => "",
                        payment_type         => "",
                        person_id            => "",
                        sent_dt              => "",
                        type                 => "GENERAL",
                        unilateral           => 0,
                        update_dt            => "2015-04-02",
                    },
                    Person => {},
                },
            ];
        };

        my $data = $app->agreement_checker->get_data_for_client_id(client_id => 302354,);
        cmp_deeply(
            $data,
            {
                today => {
                    context_on_site_adblock  => 1,
                    context_on_site_content  => 1,
                    context_on_site_direct   => 1,
                    context_on_site_natural  => 1,
                    context_on_site_rtb      => 1,
                    context_on_site_stripe   => 1,
                    indoor_block             => 1,
                    mobile_app_rtb           => 1,
                    outdoor_block            => 1,
                    search_on_site_direct    => 1,
                    search_on_site_market    => 1,
                    search_on_site_mcb       => 1,
                    search_on_site_premium   => 1,
                    video_an_site_fullscreen => 1,
                    video_an_site_inpage     => 1,
                    video_an_site_instream   => 1,
                },
                tomorrow => {
                    context_on_site_adblock  => 1,
                    context_on_site_content  => 1,
                    context_on_site_direct   => 1,
                    context_on_site_natural  => 1,
                    context_on_site_rtb      => 1,
                    context_on_site_stripe   => 1,
                    indoor_block             => 1,
                    mobile_app_rtb           => 1,
                    outdoor_block            => 1,
                    search_on_site_direct    => 1,
                    search_on_site_market    => 1,
                    search_on_site_mcb       => 1,
                    search_on_site_premium   => 1,
                    video_an_site_fullscreen => 1,
                    video_an_site_inpage     => 1,
                    video_an_site_instream   => 1,
                },
            },
            'logint=officengsru'
        );

        my $m_ru_text_data = $app->agreement_checker->get_data_for_client_id(client_id => 486246);
        cmp_deeply(
            $m_ru_text_data,
            {
                today => {
                    context_on_site_direct  => 1,
                    search_on_site_direct   => 1,
                    search_on_site_premium  => 1,
                    context_on_site_adblock => 1,
                },
                tomorrow => {
                    context_on_site_direct  => 1,
                    search_on_site_direct   => 1,
                    search_on_site_premium  => 1,
                    context_on_site_adblock => 1,
                },
            },
            'login=m-ru-text'
        );

        my $adinside_data = $app->agreement_checker->get_data_for_client_id(client_id => $ADINSIDE_CLIENT_ID);
        cmp_deeply(
            $adinside_data,
            {
                'today' => {
                    'context_on_site_adblock'  => 1,
                    'context_on_site_content'  => 1,
                    'context_on_site_direct'   => 1,
                    context_on_site_natural    => 1,
                    'context_on_site_rtb'      => 1,
                    'context_on_site_stripe'   => 1,
                    'indoor_block'             => 1,
                    'mobile_app_rtb'           => 1,
                    'outdoor_block'            => 1,
                    'search_on_site_direct'    => 1,
                    'search_on_site_market'    => 1,
                    'search_on_site_mcb'       => 1,
                    'search_on_site_premium'   => 1,
                    'video_an_site_fullscreen' => 1,
                    'video_an_site_inpage'     => 1,
                    'video_an_site_instream'   => 1
                },
                'tomorrow' => {
                    'context_on_site_adblock'  => 1,
                    'context_on_site_content'  => 1,
                    context_on_site_natural    => 1,
                    'context_on_site_direct'   => 1,
                    'context_on_site_rtb'      => 1,
                    'context_on_site_stripe'   => 1,
                    'indoor_block'             => 1,
                    'mobile_app_rtb'           => 1,
                    'outdoor_block'            => 1,
                    'search_on_site_direct'    => 1,
                    'search_on_site_market'    => 1,
                    'search_on_site_mcb'       => 1,
                    'search_on_site_premium'   => 1,
                    'video_an_site_fullscreen' => 1,
                    'video_an_site_inpage'     => 1,
                    'video_an_site_instream'   => 1
                }
            },
            'login=adinside'
        );

        my $yantest2016_data = $app->agreement_checker->get_data_for_client_id(client_id => 8933103);
        cmp_deeply(
            $yantest2016_data,
            {
                today    => {mobile_app_rtb => 1,},
                tomorrow => {mobile_app_rtb => 1,},
            },
            'login=yantest2016'
        );

        my $yantestnew2016_data = $app->agreement_checker->get_data_for_client_id(client_id => 9143013);
        cmp_deeply(
            $yantestnew2016_data,
            {
                today => {
                    video_an_site_inpage   => 1,
                    video_an_site_instream => 1,
                    mobile_app_rtb         => 1,
                },
                tomorrow => {
                    video_an_site_inpage   => 1,
                    video_an_site_instream => 1,
                    mobile_app_rtb         => 1,
                },
            },
            'login=yantestnew2016'
        );
    },
    init => [qw(api_balance)]
);
