#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Differences;
use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $data = $app->partner_db->all_pages->get_all(
            fields => {
                page_id => '',
                count   => {count => ['page_id']}
            },
            group_by => ['page_id'],
            having   => ['count', '>', \1],
            order_by => ['page_id']
        );

        my $page_ids = [map {$_->{page_id}} @$data];

        my $expect = [];
        my $got    = $app->partner_db->all_pages->get_all(
            fields => ['page_id', 'model'],
            filter => {'page_id' => $page_ids},
            order_by => ['page_id', 'model']
        );
        eq_or_diff($got, $expect, 'No same page_id in different models');
    },
);
