#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock qw( mock_subs  mock_curdate );

use Test::More;
use Test::Deep qw(cmp_deeply);
use YAML::Syck qw(LoadFile DumpFile);

use qbit;

my $TESTS_DATA = {
    'page_ids' => {
        params => {
            page_ids   => [142898, 41443],
            chunk_size => 1,
        },
        error => '',
    },
    'empty_page_ids' => {
        params => {
            page_ids   => [],
            chunk_size => 1,
        },
        error => '',
    },
    'pages' => {
        params => {
            pages => [
                {
                    model => 'context_on_site_campaign',
                    id    => 142898
                },
                {
                    model => 'video_an_site',
                    id    => 128972
                }
            ],
        },
        error => '',
    },
    'empty_pages' => {
        params => {pages => [],},
        error  => '',
    },
    'models' => {
        params => {
            models        => ['context_on_site_campaign'],
            min_send_date => '2018-08-01 01:10:20',
        },
        error => '',
    },
    'empty_models' => {
        params => {models => [],},
        error  => '',
    },
    'pages_and_page_ids' => {
        params => {
            pages => [
                {
                    model => 'video_an_site',
                    id    => 128972
                }
            ],
            page_ids => [142898, 41443],
        },
        error => '',
    },
    'defaults' => {
        params => {},
        error  => '',
    },
    'min_send_date' => {
        params => {min_send_date => '2018-08-01 01:10:20',},
        error  => '',
    },
};

run_tests(
    sub {
        my ($app) = @_;

        my $SQL_BUFFER = [];
        mock_subs(
            {
                'QBit::Application::Model::DB::_do' => sub {
                    my ($self, $got_sql, @params) = @_;
                    push @$SQL_BUFFER, $got_sql;
                  }
            }
        );

        mock_curdate('2018-10-11 12:01:02');

        my $path_to_data = lib::abs::path('mark_pages_for_async_update/data.yaml');
        my $yaml_data    = LoadFile($path_to_data);

        my $model = $app->all_pages;

        foreach my $testname (sort keys %$TESTS_DATA) {
            my ($params, $expect_error) = @{$TESTS_DATA->{$testname}}{qw(  params  error )};

            $SQL_BUFFER = [];

            subtest $testname => sub {
                my $got_error = '';
                try {
                    $app->all_pages->mark_pages_for_async_update(%$params);
                }
                catch {
                    $got_error = shift->message;
                };

                my $expect_queries = $yaml_data->{$testname};
                cmp_deeply($SQL_BUFFER, $expect_queries, 'SQL');
                $yaml_data->{$testname} = $SQL_BUFFER;

                is($got_error, $expect_error, 'error message');
            };
        }

        # Usage: > ./prove *.t :: --self_update 2>&1 | less
        if (need_self_update()) {
            open(my $fh, ">:encoding(UTF-8)", $path_to_data);
            DumpFile($fh, $yaml_data);
        }

    },
    do_not_die_on_fail => TRUE,
    mocks              => ['mock_sort_sql'],
);
