#!/usr/bin/perl -w

# Usage: > ./prove2 *.t :: --self_update 2>&1 | less

use strict;
use warnings FATAL => 'all';

use Test::Partner::Utils;
use Test::Partner2::Mock;
use Test::Partner2::Simple;

use Test::Differences;
use Test::More;

use qbit;

my $table_data = [
    {
        name      => 'contract was closed long time ago',
        client_id => 11001,
        end_dt    => '2021-05-01',
    },
    {
        name      => 'contract is closing today',
        client_id => 11002,
        end_dt    => '2021-05-27'
    },
    {
        name      => 'contract is closing tomorrow',
        client_id => 11003,
        end_dt    => '2021-05-28'
    },
    {
        name      => 'contract is closing over week',
        client_id => 11004,
        end_dt    => '2021-06-03'
    },
    {
        name      => 'contract is closing over week without money',
        client_id => 11005,
        end_dt    => '2021-06-03'
    },
];

run_tests(
    \&main_test,
    do_not_die_on_fail => 1,
    init               => [qw(auto_stop)],
);

sub main_test {
    my ($app) = @_;

    mock_curdate('2021-05-27 12:00:00');
    fill_data($app, $table_data);
    mock_subs(
        {
            'Application::Model::BKStatistics::get_money_for_clients_on_dates' => sub {
                return {
                    11001 => 10,
                    11002 => 10,
                    11003 => 10,
                    11004 => 10,
                    11005 => 0,
                };
            },
        }
    );
    my %result;
    @result{qw(warn crit)} = $app->auto_stop->check_soon_auto_stop(
        after_date      => '2021-05-27',
        crit_date       => '2021-05-29',
        warn_date       => '2021-06-10',
        money_last_days => 1,
        money_per_month => 10,
    );

    my $expected = get_test_data_and_update_if_needed('data.json', \%result);
    eq_or_diff(\%result, $expected, 'check');
}

sub fill_data {
    my ($app, $data) = @_;
    $app->partner_db->contracts->delete($app->partner_db->filter([AND => [\TRUE]]));
    my $id = 1;
    foreach my $row (@$data) {
        my $name = delete $row->{name};
        $id++;
        $row->{id} //= $id;
        $row->{multistate}  = 0;
        $row->{type}        = 'PARTNERS';
        $row->{external_id} = 'RSYA-' . $row->{id};
        $row->{dt}          = '2021-01-01';
        $row->{update_dt}   = '2021-01-01';
        $row->{contract}    = '{}';
        $row->{opts}        = '{"raw_contract":{"name":"' . $name . '"}}';
    }
    $app->partner_db->contracts->add_multi($data);
}
