#!/usr/bin/perl -w

# Usage: > ./prove2 *.t :: --self_update 2>&1 | less

use strict;
use warnings FATAL => 'all';

use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Partner2::Mock qw(mock_subs mock_curdate restore_subs);
use Test::Partner2::Simple;

use Test::Differences qw(eq_or_diff);
use Test::More tests => 2 + 25;

use PiConstants qw($IS_PRECISE);

use qbit;

my $MOCK_DATE = '2021-05-27';
my $MODEL     = 'context_on_site_campaign';
my $CLIENT_ID = 11009;
my $USER_ID   = 1009;
my %FILE_MAP  = (
    '2021_05_27_00_00_00' => '2021_05_27_00_00_00',
    '2021_05_27_01_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_02_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_03_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_04_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_05_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_06_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_07_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_08_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_09_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_10_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_11_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_12_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_13_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_14_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_15_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_16_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_17_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_18_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_19_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_20_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_21_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_22_00_00' => '2021_05_27_01_00_00',
    '2021_05_27_23_00_00' => '2021_05_27_23_00_00',
    '2021_05_28_00_00_00' => '2021_05_28_00_00_00',
);

run_tests(
    sub {
        my ($app) = @_;

        my @test_data;
        my $add_test_data = sub {
            shift @_ if blessed $_[0];
            push @test_data, [@_] if caller eq 'Application::Model::AutoStop';
        };
        mock_subs(
            {
                'Application::Model::AgreementChecker::has_agreement_for_any_product_for_tomorrow' => sub {FALSE},
                'Application::Model::AutoStop::INFO'             => $add_test_data,
                'Application::Model::AutoStop::INFOF'            => $add_test_data,
                'Application::Model::AutoStop::send_to_graphite' => $add_test_data,
                'Application::Model::MailNotification::add'      => $add_test_data,
            }
        );

        my $data = {
            id          => 123,
            multistate  => 0,
            type        => 'PARTNERS',
            external_id => 'RSYA-123',
            client_id   => $CLIENT_ID,
            dt          => '2021-01-01',
            end_dt      => '2021-05-01',
            update_dt   => '2021-01-01',
            contract    => '{}',
            opts        => '{}',
        };
        $app->partner_db->contracts->add($data);

        foreach my $i (0 .. 24) {
            my $dt = date_add($MOCK_DATE, iformat => 'db', oformat => 'db_time', hour => $i);
            mock_curdate($dt);
            @test_data = ();
            push @test_data, '-=- Pages data before check -=-';
            push @test_data, $app->$MODEL->get_all(
                fields => [qw(page_id multistate multistate_name)],
                filter => {owner_id => $USER_ID,},
            );
            push @test_data, '-=- Start preparing -=-';
            $app->auto_stop->prepare_auto_stop(
                model => $app->$MODEL,
                products_for_agreement_checker =>
                  $app->product_manager->get_block_accessors_by_page_n_tag($MODEL, 'can_auto_stop'),
            );
            push @test_data, '-=- Auto stop data -=-';
            push @test_data, $app->partner_db->cron_auto_stop->get_all(
                fields => [qw(id dt model user_id keep_working)],
                filter => [AND => [[user_id => '=' => \$USER_ID]]],
            );
            push @test_data, '-=- Auto stop -=-';
            $app->auto_stop->do_auto_stop(
                model => $app->$MODEL,
                products_for_agreement_checker =>
                  $app->product_manager->get_block_accessors_by_page_n_tag($MODEL, 'can_auto_stop'),
            );
            push @test_data, '-=- Pages data after check -=-';
            push @test_data, $app->$MODEL->get_all(
                fields => [qw(page_id multistate multistate_name)],
                filter => {owner_id => $USER_ID,},
            );
            push @test_data, '-=- END -=-';

            if ($IS_PRECISE) {
                foreach my $el (grep {ref $_ eq 'HASH'} map {@$_} grep {ref $_ eq 'ARRAY'} @test_data) {
                    map {$el->{$_} += 0 if exists $el->{$_}} qw( id keep_working multistate page_id user_id );
                    if (exists $el->{values} && exists $el->{values}->{plain_text_wrapper}) {
                        $el->{values}->{plain_text_wrapper} .= "";
                    }
                }
            }

            my $file_name = $dt;
            $file_name =~ s/\D/_/g;
            $file_name = $FILE_MAP{$file_name} or fail 'File map is not set';
            $file_name .= '.json';
            my $expected = get_test_data_and_update_if_needed($file_name, \@test_data);
            eq_or_diff(\@test_data, $expected, $dt, {context => 10});
        }
    },
    do_not_die_on_fail => 1,
    init               => [qw(agreement_checker auto_stop mail_notification product_manager)],
);
