#!/usr/bin/perl -w

# Usage: > ./prove2 *.t :: --self_update 2>&1 | less

use strict;
use warnings FATAL => 'all';

use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Partner2::Mock qw(mock_subs mock_curdate restore_subs);
use Test::Partner2::Simple;

use Test::Differences qw(eq_or_diff);
use Test::More tests => 2 + 4;

use qbit;

my $MOCK_DATE = '2021-05-27';
my $MODEL     = 'context_on_site_campaign';
my $CLIENT_ID = 11009;

my $app;
my @test_data;

run_tests(
    sub {
        ($app) = @_;

        my $add_test_data = sub {
            push @test_data, [@_];
        };
        mock_curdate($MOCK_DATE . ' 12:00:00');
        mock_subs(
            {
                'Application::Model::AgreementChecker::has_agreement_for_any_product_for_tomorrow' => sub {TRUE},
                'Application::Model::AutoStop::INFO'             => $add_test_data,
                'Application::Model::AutoStop::send_to_graphite' => $add_test_data,
            }
        );

        make_test(
            name => 'contract was closed long time ago',
            data => [{end_dt => '2021-05-01',},]
        );

        make_test(
            name => 'contract is closing today',
            data => [{end_dt => $MOCK_DATE,},]
        );

        make_test(
            name => 'contract is closing tomorrow',
            data => [{end_dt => '2021-05-28',},]
        );

        make_test(
            name => 'contract is closing today with new contract tomorrow',
            data => [{end_dt => $MOCK_DATE,}, {dt => '2021-05-28',},]
        );
    },
    do_not_die_on_fail => 1,
    init               => [qw(agreement_checker auto_stop product_manager)],
);

sub make_test {
    my (%opts) = @_;

    my $id = 123;
    $app->partner_db->contracts->delete($app->partner_db->filter([AND => [\TRUE]]));
    $app->partner_db->cron_auto_stop->delete($app->partner_db->filter([AND => [\TRUE]]));
    foreach my $row (@{$opts{data}}) {
        $row->{id} //= $id++;
        $row->{multistate} = 0;
        $row->{type}       = 'PARTNERS';
        $row->{external_id} //= 'RSYA-' . $row->{id};
        $row->{client_id}   //= $CLIENT_ID;
        $row->{dt}          //= '2021-01-01';
        $row->{update_dt}   //= '2021-01-01';
        $row->{contract}    //= '{}';
        $row->{opts}        //= '{}';
    }
    $app->partner_db->contracts->add_multi($opts{data});

    @test_data = ();
    $app->auto_stop->prepare_auto_stop(
        model => $app->$MODEL,
        products_for_agreement_checker =>
          $app->product_manager->get_block_accessors_by_page_n_tag($MODEL, 'can_auto_stop'),
    );

    my $file_name = $opts{name};
    $file_name =~ s/\s/_/g;
    $file_name .= '.json';
    my $expected = get_test_data_and_update_if_needed($file_name, \@test_data);
    eq_or_diff(\@test_data, $expected, $opts{name}, {context => 10});
}
