use strict;
use warnings FATAL => 'all';

use PiConstants qw($MOL_REPORT_TYPE_MAIN $MOL_REPORT_TYPE_MM);

use Test::Partner2::Simple;

use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Partner::Utils;
use Test::Differences;

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2016-07-28 14:26:18');

        my @FILTER;
        my $i = 0;
        no warnings 'redefine';
        no strict 'refs';
        my $sub_get_all_orig = \&QBit::Application::Model::DBManager::get_all;
        local *{'QBit::Application::Model::DBManager::get_all'} = sub {
            my ($self, %opts) = @_;
            my $table_name = $self->partner_db_table()->name;
            unless (($opts{'limit'} && $opts{'limit'} == 1)
                || grep {$table_name eq $_} qw( assistants users user_features ))
            {
                $FILTER[$i] //= [];
                push @{$FILTER[$i]}, {$table_name => $opts{filter}};
            }

            return $sub_get_all_orig->($self, %opts);
        };
        my $sub_get_assistants_orig = \&Application::Model::Assistants::get_assistants;
        local *{'Application::Model::Assistants::get_assistants'} = sub {
            my ($self, %opts) = @_;
            $FILTER[$i] //= [];
            push @{$FILTER[$i]}, {'get_assistants' => $opts{filter}};

            return $sub_get_assistants_orig->($self, %opts);
        };

        my @tests = (
            {
                name  => 'simple request',
                input => {
                    dimension_fields => ["date|day",],
                    dimension_filter => undef,
                    entity_fields    => ["page_id",],
                    fields           => ["clicks_direct",],
                    period           => "30days",
                    total            => 0,
                    vat              => -1,
                    limits           => {
                        limit  => 15,
                        offset => 0,
                    },
                },
            },
            {
                name  => 'limits',
                input => {
                    dimension_fields => ["date|day",],
                    dimension_filter => undef,
                    entity_fields    => ["page_id",],
                    fields           => ["clicks_direct",],
                    period           => "30days",
                    total            => 0,
                    vat              => -1,
                    limits           => {
                        offset => 100,
                        limit  => 20,
                    }
                },
            },
            {
                name  => 'filters_pre',
                input => {
                    dimension_fields => ["date|day",],
                    dimension_filter => undef,
                    entity_fields    => ["page_id",],
                    fields           => ["clicks_direct",],
                    levels           => [
                        {
                            filter => ["AND", [["domain", "LIKE", "yandex",],],],
                            id => "payment",
                        },
                    ],
                    period => "30days",
                    total  => 0,
                    vat    => -1,
                    limits => {
                        limit  => 15,
                        offset => 0,
                    },
                },
            },
            {
                name  => 'page_level',
                input => {
                    dimension_fields => [],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['shows_direct',],
                    levels           => [
                        {
                            filter => [
                                'AND',
                                [
                                    [
                                        'page_level', '=',
                                        ['context_on_site_campaign', 'internal_context_on_site_campaign',],
                                    ],
                                ],
                            ],
                            id => 'payment',
                        },
                    ],
                    limits => {
                        limit  => 50,
                        offset => 0,
                    },
                    order_by => [],
                    period   => '7days',
                    total    => 0,
                    vat      => -1,
                },
            },
            {
                name  => 'in',
                input => {
                    dimension_fields => [],
                    dimension_filter => undef,
                    entity_fields    => ['dsp_id'],
                    fields           => ['all_wo_nds'],
                    levels           => [
                        {
                            'filter' => ['AND', [['dsp_id', 'IN', ['1', '10']]]],
                            'id' => 'payment',
                        }
                    ],
                    limits => {
                        'limit'  => 50,
                        'offset' => 0,
                    },
                    order_by => [
                        {
                            'dir'   => 'desc',
                            'field' => 'dsp_id',
                        },
                        {
                            'dir'   => 'desc',
                            'field' => 'all_wo_nds',
                        }
                    ],
                    period => 'today',
                    total  => 0,
                    vat    => -1,
                },
            },
            {
                name  => 'public_id',
                input => {
                    dimension_fields => [],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['partner_wo_nds',],
                    levels           => [
                        {
                            filter =>
                              ['AND', [['public_id', 'IN', ['R-A-238730-4', 'R-A-228614-2', 'R-A-238730-5'],],],],
                            id => 'payment',
                        },
                    ],
                    limits => {
                        limit  => 50,
                        offset => 0,
                    },
                    order_by => [
                        {
                            dir   => 'desc',
                            field => 'partner_wo_nds',
                        },
                        {
                            dir   => 'desc',
                            field => 'partner_wo_nds',
                        },
                    ],
                    period => 'today',
                    total  => 0,
                    vat    => -1,
                },
            },
            {
                name  => 'public_id NOT IN',
                input => {
                    dimension_fields => [],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['partner_wo_nds',],
                    levels           => [
                        {
                            filter =>
                              ['AND', [['public_id', 'NOT IN', ['R-A-238730-4', 'R-A-228614-2', 'R-A-238730-5'],],],],
                            id => 'payment',
                        },
                    ],
                    limits => {
                        limit  => 50,
                        offset => 0,
                    },
                    order_by => [
                        {
                            dir   => 'desc',
                            field => 'partner_wo_nds',
                        },
                        {
                            dir   => 'desc',
                            field => 'partner_wo_nds',
                        },
                    ],
                    period => 'today',
                    total  => 0,
                    vat    => -1,
                },
            },
            {
                name  => 'public_id IN & NOT IN',
                input => {
                    dimension_fields => [],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['partner_wo_nds',],
                    levels           => [
                        {
                            filter => [
                                'AND',
                                [
                                    ['public_id', 'IN', ['R-A-238730-4', 'R-A-228614-2', 'R-A-238730-5']],
                                    ['public_id', 'NOT IN', ['R-A-238730-4']]
                                ]
                            ],
                            id => 'payment',
                        },
                    ],
                    limits => {
                        limit  => 50,
                        offset => 0,
                    },
                    order_by => [
                        {
                            dir   => 'desc',
                            field => 'partner_wo_nds',
                        },
                        {
                            dir   => 'desc',
                            field => 'partner_wo_nds',
                        },
                    ],
                    period => 'today',
                    total  => 0,
                    vat    => -1,
                },
            },
            {
                name  => 'login => page_id',
                input => {
                    dimension_fields => [],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['partner_wo_nds',],
                    levels           => [
                        {
                            filter => [
                                'AND',
                                [
                                    ['login', 'IN', ['mocked-yan-partner', 'mocked-video-partner']],
                                    ['page_id', 'NOT IN', [128972, 41443]]
                                ]
                            ],
                            id => 'payment',
                        },
                    ],
                    limits => {
                        limit  => 50,
                        offset => 0,
                    },
                    order_by => [
                        {
                            dir   => 'desc',
                            field => 'partner_wo_nds',
                        },
                    ],
                    period => 'today',
                    total  => 0,
                    vat    => -1,
                },
            },
            {
                name  => 'DSP login => DSPID',
                input => {
                    stat_type        => 'dsp',
                    dimension_fields => [],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['price_dsp', 'all_wo_nds'],
                    levels           => [
                        {
                            filter => ['AND', [['login', 'IN', ['mocked-dsp-partner']]]],
                            id => 'payment',
                        },
                    ],
                    period => 'today',
                    total  => 0,
                    vat    => -1,
                },
            },
            {
                name  => 'geo country',
                input => {
                    dimension_fields => ["date|day", "geo|country"],
                    dimension_filter => undef,
                    entity_fields    => ["page_id",],
                    fields           => ["clicks_direct",],
                    period           => "30days",
                    total            => 0,
                    vat              => -1,
                    limits           => {
                        limit  => 15,
                        offset => 0,
                    },
                },
            },
            {
                name  => 'user without Page IDs',
                login => 'mocked-yan-partner-no-campaigns',
                input => {
                    dimension_fields => ["date|day"],
                    dimension_filter => undef,
                    entity_fields    => ["page_id",],
                    fields           => ["clicks_direct",],
                    period           => "30days",
                    total            => 0,
                    vat              => -1,
                    limits           => {
                        limit  => 15,
                        offset => 0,
                    },
                },
            },
            {
                name  => 'partner is trying to access Page ID that he does not have access to',
                login => 'mocked-yan-partner',
                input => {
                    dimension_fields => ['date|day'],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['partner_wo_nds'],
                    period           => 'today',
                    levels           => [{filter => ['AND', [['page_id', '=', '147035']]], 'id' => 'payment'}],
                    total            => 0,
                    vat              => -1,
                    limits           => {
                        limit  => 15,
                        offset => 0,
                    },
                },
            },
            {
                name  => 'assistant is trying to access Page ID that he have access to',
                login => 'mocked-yan-partner-assistant',
                input => {
                    dimension_fields => ['date|day'],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['partner_wo_nds'],
                    period           => 'today',
                    levels           => [{filter => ['AND', [['page_id', '=', '41443']]], 'id' => 'payment'}],
                    total            => 0,
                    vat              => -1,
                    limits           => {
                        limit  => 15,
                        offset => 0,
                    },
                },
            },
            {
                name  => 'assistant is trying to access Page ID that he does not have access to',
                login => 'mocked-yan-partner-assistant',
                input => {
                    dimension_fields => ['date|day'],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['partner_wo_nds'],
                    period           => 'today',
                    levels           => [{filter => ['AND', [['page_id', '=', '147035']]], 'id' => 'payment'}],
                    total            => 0,
                    vat              => -1,
                    limits           => {
                        limit  => 15,
                        offset => 0,
                    },
                },
            },
            {
                name  => 'partner is trying to access all Pages',
                login => 'mocked-yan-partner',
                input => {
                    dimension_fields => ['date|day'],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['partner_wo_nds'],
                    period           => 'today',
                    total            => 0,
                    vat              => -1,
                    limits           => {
                        limit  => 15,
                        offset => 0,
                    },
                },
            },
            {
                name  => 'assistant is trying to access all Pages',
                login => 'mocked-yan-partner-assistant',
                input => {
                    dimension_fields => ['date|day'],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['partner_wo_nds'],
                    period           => 'today',
                    total            => 0,
                    vat              => -1,
                    limits           => {
                        limit  => 15,
                        offset => 0,
                    },
                },
            },
            {
                name  => 'partner selecting by dsp_display_caption',
                login => 'mocked-yan-partner',
                input => {
                    dimension_fields => ['date|day'],
                    dimension_filter => undef,
                    entity_fields    => ['dsp_display_caption'],
                    fields           => ['partner_wo_nds'],
                    period           => 'today',
                    levels => [{'filter' => ['AND', [['dsp_display_caption', '=', 'TargetRTB']]], 'id' => 'payment'}],
                    total  => 0,
                    vat    => -1,
                    limits => {
                        limit  => 15,
                        offset => 0,
                    },
                },
            },
            {
                name  => 'dev requesting PageModel as page_level',
                input => {
                    dimension_fields => ['date|day'],
                    dimension_filter => undef,
                    entity_fields    => ['page_level'],
                    fields           => ['partner_wo_nds'],
                    period           => 'today',
                    levels           => [
                        {
                            filter =>
                              ['AND', [['page_level', 'IN', ['context_on_site_campaign', 'mobile_app_settings']]]],
                            'id' => 'payment'
                        }
                    ],
                    total  => 0,
                    vat    => -1,
                    limits => {
                        limit  => 15,
                        offset => 0,
                    },
                },
            },
            {
                name  => 'dev requesting BlockModel/PageModel as page_level/block_level',
                input => {
                    dimension_fields => ['date|day'],
                    dimension_filter => undef,
                    entity_fields    => ['page_level', 'block_level'],
                    fields           => ['partner_wo_nds'],
                    period           => 'today',
                    levels           => [
                        {
                            filter => [
                                'AND',
                                [
                                    ['page_level', 'IN', ['context_on_site_campaign']],
                                    ['block_level', 'IN', ['context_on_site_rtb', 'context_on_site_content']]
                                ]
                            ],
                            'id' => 'payment'
                        }
                    ],
                    total  => 0,
                    vat    => -1,
                    limits => {
                        limit  => 15,
                        offset => 0,
                    },
                },
            },
            {
                name  => 'dev requesting incostistent BlockModel/PageModel',
                input => {
                    dimension_fields => ['date|day'],
                    dimension_filter => undef,
                    entity_fields    => ['page_level', 'block_level'],
                    fields           => ['partner_wo_nds'],
                    period           => 'today',
                    levels           => [
                        {
                            filter => [
                                'AND',
                                [
                                    ['page_level',  'IN', ['context_on_site_campaign']],
                                    ['block_level', 'IN', ['video_an_site_instream']]
                                ]
                            ],
                            'id' => 'payment'
                        }
                    ],
                    total  => 0,
                    vat    => -1,
                    limits => {
                        limit  => 15,
                        offset => 0,
                    },
                },
            },
            {
                name  => 'request with period compare',
                input => {
                    dimension_fields => ["date|day",],
                    entity_fields    => ["page_id",],
                    fields           => ["shows", "partner_wo_nds",],
                    period           => [["2021-01-09", "2021-01-16"], ["2021-01-01", "2021-01-08"]],
                    total            => 0,
                    order_by         => [{"field" => "shows", "dir" => "asc"}, {"field" => "page_id", "dir" => "desc"}],
                    limits           => {
                        limit  => 100,
                        offset => 0,
                    },
                },
            },
            {
                name  => 'request with period compare date swap',
                input => {
                    dimension_fields => ["date|day",],
                    entity_fields    => ["page_id",],
                    fields           => ["shows", "partner_wo_nds",],
                    period           => [["2020-01-01", "2020-01-01"], ["2021-01-01", "2021-01-01"],],
                    total            => 0,
                    order_by         => [{"field" => "shows", "dir" => "asc"}, {"field" => "page_id", "dir" => "desc"}],
                    limits           => {
                        limit  => 100,
                        offset => 0,
                    },
                },
            },
            {
                name  => 'partner excluding PageID',
                login => 'mocked-yan-partner',
                input => {
                    dimension_fields => ['date|day'],
                    entity_fields    => ['page_id'],
                    fields           => ['partner_wo_nds'],
                    period           => 'today',
                    levels =>
                      [{'filter' => ['AND', [['page_id', '<>', 1], ['page_id', 'NOT IN', 799]]], 'id' => 'payment'}],
                    total => 0,
                },
            },
            {
                name  => 'partner excluding PageID',
                login => 'mocked-yan-partner',
                input => {
                    dimension_fields => ['date|day'],
                    entity_fields    => ['page_id'],
                    fields           => ['partner_wo_nds'],
                    period           => 'today',
                    levels =>
                      [{'filter' => ['AND', [['page_id', 'NOT IN', 799], ['page_id', '<>', 1]]], 'id' => 'payment'}],
                    total => 0,
                },
            },
            {
                name  => 'complex_block_id as group',
                input => {
                    dimension_fields => [],
                    dimension_filter => undef,
                    entity_fields    => ['complex_block_id'],
                    fields           => ['partner_wo_nds',],
                    levels           => [
                        {
                            filter =>
                              ['AND', [['public_id', 'IN', ['R-A-238730-4', 'R-A-228614-2', 'R-A-238730-5'],],],],
                            id => 'payment',
                        },
                    ],
                    order_by => [
                        {
                            dir   => 'desc',
                            field => 'partner_wo_nds',
                        },
                    ],
                    period => 'today',
                    total  => 0,
                    vat    => -1,
                },
            },
            {
                name  => 'complex_block_id as group & filter',
                input => {
                    stat_type        => $MOL_REPORT_TYPE_MM,
                    dimension_fields => [],
                    dimension_filter => undef,
                    entity_fields    => ['complex_block_id'],
                    fields           => ['revenue_mm'],
                    levels           => [
                        {
                            filter => [
                                'AND', [['complex_block_id', 'IN', ['R-A-238730-4', 'R-A-228614-2', 'R-A-238730-5'],],],
                            ],
                            id => 'payment',
                        },
                    ],
                    order_by => [
                        {
                            dir   => 'desc',
                            field => 'revenue_mm',
                        },
                    ],
                    period => 'today',
                    total  => 0,
                    vat    => -1,
                }
            },
            {
                name  => 'partner select RegionID',
                login => 'mocked-yan-partner',
                input => {
                    dimension_fields => ['date|day'],
                    entity_fields    => ['region_id'],
                    fields           => ['partner_wo_nds'],
                    period           => 'today',
                    levels           => [{'filter' => undef, 'id' => 'payment'}],
                    total            => 0,
                },
            },
            {
                name  => 'partner select DesignID signed',
                login => 'mocked-yan-partner',
                input => {
                    dimension_fields => ['date|day'],
                    entity_fields    => ['design_id'],
                    fields           => ['partner_wo_nds'],
                    period           => 'today',
                    levels           => [{'filter' => ['AND', [['design_id', 'IN', [0, -1]]]], 'id' => 'payment'}],
                    total            => 0,
                },
            },
            {
                name  => 'login && page_id',
                input => {
                    dimension_fields => [],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['partner_wo_nds',],
                    levels           => [
                        {
                            filter => [
                                'AND',
                                [
                                    ['login', 'IN', ['mocked-yan-partner', 'mocked-video-partner']],
                                    ['page_id', 'IN', [128972, 41443]]
                                ]
                            ],
                            id => 'payment',
                        },
                    ],
                    limits => {
                        limit  => 50,
                        offset => 0,
                    },
                    order_by => [
                        {
                            dir   => 'desc',
                            field => 'partner_wo_nds',
                        },
                    ],
                    period => 'today',
                    total  => 0,
                    vat    => -1,
                },
            },
            {
                name  => 'public_id & login',
                input => {
                    dimension_fields => [],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['partner_wo_nds',],
                    levels           => [
                        {
                            filter => [
                                'AND',
                                [
                                    ['public_id', 'IN', ['R-A-128972-4', 'R-A-41443-2', 'R-A-41443-5']],
                                    ['login', 'IN', ['mocked-yan-partner', 'mocked-video-partner']],
                                ]
                            ],
                            id => 'payment',
                        },
                    ],
                    limits => {
                        limit  => 50,
                        offset => 0,
                    },
                    order_by => [
                        {
                            dir   => 'desc',
                            field => 'partner_wo_nds',
                        },
                        {
                            dir   => 'desc',
                            field => 'partner_wo_nds',
                        },
                    ],
                    period => 'today',
                    total  => 0,
                    vat    => -1,
                },
            },
            {
                name  => 'partner & page_id',
                login => 'mocked-yan-partner',
                input => {
                    dimension_fields => ['date|day'],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['partner_wo_nds'],
                    period           => 'today',
                    levels           => [{filter => ['AND', [['page_id', '=', '41443']]], 'id' => 'payment'}],
                    total            => 0,
                    vat              => -1,
                    limits           => {
                        limit  => 15,
                        offset => 0,
                    },
                },
            },
            {
                name  => 'login & foreign page_id',
                input => {
                    dimension_fields => [],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['partner_wo_nds',],
                    levels           => [
                        {
                            filter => ['AND', [['login', 'IN', ['mocked-video-partner']], ['page_id', 'IN', [41443]]]],
                            id => 'payment',
                        },
                    ],
                    order_by => [
                        {
                            dir   => 'desc',
                            field => 'partner_wo_nds',
                        },
                    ],
                    period => 'today',
                    total  => 0,
                    vat    => -1,
                },
            },
            {
                name  => 'login & foreign public_id',
                input => {
                    dimension_fields => [],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['partner_wo_nds',],
                    levels           => [
                        {
                            filter => [
                                'AND',
                                [
                                    ['public_id', 'IN', ['R-A-41443-2', 'R-A-41443-5']],
                                    ['login', 'IN', ['mocked-video-partner']],
                                ]
                            ],
                            id => 'payment',
                        },
                    ],
                    order_by => [
                        {
                            dir   => 'desc',
                            field => 'partner_wo_nds',
                        },
                    ],
                    period => 'today',
                    total  => 0,
                    vat    => -1,
                },
            },
            {
                name  => 'bad login & page_id',
                input => {
                    dimension_fields => [],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['partner_wo_nds',],
                    levels           => [
                        {
                            filter => ['AND', [['login', 'IN', ['bad-user']], ['page_id', 'IN', [41443]]]],
                            id => 'payment',
                        },
                    ],
                    order_by => [
                        {
                            dir   => 'desc',
                            field => 'partner_wo_nds',
                        },
                    ],
                    period => 'today',
                    total  => 0,
                    vat    => -1,
                },
            },
            {
                name  => 'bad login',
                input => {
                    dimension_fields => [],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['partner_wo_nds',],
                    levels           => [
                        {
                            filter => ['AND', [['login', 'IN', ['bad-user']]]],
                            id => 'payment',
                        },
                    ],
                    order_by => [
                        {
                            dir   => 'desc',
                            field => 'partner_wo_nds',
                        },
                    ],
                    period => 'today',
                    total  => 0,
                    vat    => -1,
                },
            },
            {
                name  => 'login and page => NOT IN',
                input => {
                    dimension_fields => [],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['partner_wo_nds',],
                    levels           => [
                        {
                            filter => [
                                'AND',
                                [
                                    ['login', 'NOT IN', ['mocked-yan-partner', 'mocked-video-partner']],
                                    ['page_id', 'NOT IN', ['4143']],
                                ]
                            ],
                            id => 'payment',
                        },
                    ],
                    limits => {
                        limit  => 50,
                        offset => 0,
                    },
                    order_by => [
                        {
                            dir   => 'desc',
                            field => 'partner_wo_nds',
                        },
                    ],
                    period => 'today',
                    total  => 0,
                    vat    => -1,
                },
            },
            {
                name  => 'login => NOT IN and page => IN',
                input => {
                    dimension_fields => [],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['partner_wo_nds',],
                    levels           => [
                        {
                            filter =>
                              ['AND', [['login', 'NOT IN', ['mocked-video-partner']], ['page_id', 'IN', ['4143']],]],
                            id => 'payment',
                        },
                    ],
                    limits => {
                        limit  => 50,
                        offset => 0,
                    },
                    order_by => [
                        {
                            dir   => 'desc',
                            field => 'partner_wo_nds',
                        },
                    ],
                    period => 'today',
                    total  => 0,
                    vat    => -1,
                },
            },
            {
                name  => 'login => NOT IN',
                input => {
                    dimension_fields => [],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['partner_wo_nds',],
                    levels           => [
                        {
                            filter => ['AND', [['login', 'NOT IN', ['mocked-yan-partner', 'mocked-video-partner']],]],
                            id => 'payment',
                        },
                    ],
                    limits => {
                        limit  => 50,
                        offset => 0,
                    },
                    order_by => [
                        {
                            dir   => 'desc',
                            field => 'partner_wo_nds',
                        },
                    ],
                    period => 'today',
                    total  => 0,
                    vat    => -1,
                },
            },
            {
                name  => 'login => IN',
                input => {
                    dimension_fields => [],
                    dimension_filter => undef,
                    entity_fields    => [],
                    fields           => ['partner_wo_nds',],
                    levels           => [
                        {
                            filter => ['AND', [['login', 'IN', ['mocked-yan-partner', 'mocked-video-partner']],]],
                            id => 'payment',
                        },
                    ],
                    limits => {
                        limit  => 50,
                        offset => 0,
                    },
                    order_by => [
                        {
                            dir   => 'desc',
                            field => 'partner_wo_nds',
                        },
                    ],
                    period => 'today',
                    total  => 0,
                    vat    => -1,
                },
            },
        );

        my @result;
        foreach my $t (@tests) {
            $t->{login} //= 'yndx-developer';
            change_cur_user($app, $t->{login});
            my $result = $app->bk_statistics->_convert_get_statistics2_to_mol_request(
                stat_type => $t->{input}{stat_type} // $MOL_REPORT_TYPE_MAIN,
                get_statistics2 => $t->{input}
            );
            push @result, [$t->{'name'}, $result, $FILTER[$i] // 'NO_FILTER'];
            $i++;
        }
        my $has_data = get_test_data_and_update_if_needed('data.json', \@result);
        eq_or_diff(\@result, $has_data, 'checks');
    },
    init => ['bk_statistics'],
);
