use qbit;

use Test::More;
use Test::Partner2::Simple;
use Test::Differences;
use Test::Partner::Utils;

use PiConstants qw($MOL_REPORT_TYPE_MAIN $MOL_REPORT_TYPE_MM);

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2016-08-01 11:19:43');

        my @tests = (
            {
                name  => 'sample',
                input => {
                    mol_response => {
                        data => [["2016-07-04", 1, 0,], ["2016-07-03", 1, 120632898,], ["2016-07-03", 2, 1775151,],],
                        duration          => 0.095,
                        error_text        => "",
                        header            => ["UpdateTime", "DSPID", "DirectShows",],
                        'host-aggregator' => "bsfastexport02i.yabs.yandex.ru",
                        stat_time         => 20160722171826,
                        status            => 0,
                        total_rows        => 25,
                        totals => {DirectShows => 125052239,},
                    },
                    date_from => '20160703',
                    date_to   => '20160704',
                    limit     => 15,
                    offset    => 0,
                }
            },
            {
                name  => 'price',
                input => {
                    mol_response => {
                        data => [
                            ["2016-08-10", 536574499, 20621410725430, 31798029883680,],
                            ["2016-08-11", 534575549, 20933630247771, 32078253658408,],
                        ],
                        duration          => 0.407,
                        error_text        => "",
                        header            => ["UpdateTime", "DirectShows", "MixedPartnerPrice", "Price",],
                        'host-aggregator' => "bsfastexport02i.yabs.yandex.ru",
                        stat_time         => 20160908134620,
                        status            => 0,
                        total_rows        => 2,
                        totals            => {
                            MixedPartnerPrice => 41555040973201,
                            Price             => 63876283542088,
                            DirectShows       => 1071150048,
                        },
                    },
                    date_from => '20160810',
                    date_to   => '20160811',
                    limit     => 15,
                    offset    => 0,
                },
            },
            {
                name  => 'product_id',
                input => {
                    mol_response => {
                        stat_time         => '20170117182424',
                        'host-aggregator' => 'bsfastexport02h.yabs.yandex.ru',
                        total_rows        => 1,
                        error_text        => '',
                        status            => 0,
                        data              => [['context_on_site_campaign', '10']],
                        duration          => '0.441',
                        header            => ['PageModel', 'DirectShows'],
                        totals            => {'DirectShows' => '10'},
                    },
                    date_from => '20170101',
                    date_to   => '20170101',
                    limit     => 15,
                    offset    => 0,
                },
            },
            {
                name  => 'geo',
                input => {
                    mol_response => {
                        data => [['Россия', 1088054529,], ['Казахстан', 65134734,],],
                        duration          => 0.085,
                        error_text        => '',
                        header            => ['RegionName', 'Price',],
                        'host-aggregator' => 'bsfastexport01e.yabs.yandex.ru',
                        stat_time         => 20180208143252,
                        status            => 0,
                        total_rows        => 55,
                        totals            => {Price => 1288760343,},
                    },
                    date_from => '20180208',
                    date_to   => '20180208',
                    limit     => 2,
                    offset    => 0,
                },
            },
            {
                name  => 'compare',
                input => {
                    'date_from'    => ['20210527', '20210528'],
                    'date_to'      => ['20210520', '20210521'],
                    'limit'        => 50,
                    'offset'       => 0,
                    'mol_response' => {
                        'data' => [
                            [
                                '2021-05-27',  '2021-05-20',        1038,  '1684',
                                '2136',        '-21.1610486891386', -452,  '257121',
                                '243100',      '5.76758535582065',  14021, '19874458744',
                                '19306880681', '2.93977091575729',  567578063
                            ],
                            [
                                '2021-05-28',  '2021-05-21',        1038,  '1853',
                                '1932',        '-4.08902691511387', -79,   '286871',
                                '224100',      '28.0102632753235',  62771, '24892774246',
                                '18636564774', '33.5695421761852',  6256209472
                            ]
                        ],
                        'duration'   => '0.193',
                        'error_text' => '',
                        'header'     => [
                            'UpdateTime_a',                'UpdateTime_b',
                            'PageID',                      'DirectBannerClicks_a',
                            'DirectBannerClicks_b',        'DirectBannerClicks_delta',
                            'DirectBannerClicks_absdelta', 'RenderShows_a',
                            'RenderShows_b',               'RenderShows_delta',
                            'RenderShows_absdelta',        'MixedPartnerPrice_a',
                            'MixedPartnerPrice_b',         'MixedPartnerPrice_delta',
                            'MixedPartnerPrice_absdelta'
                        ],
                        'host-aggregator' => 'localhost',
                        'stat_time'       => 0,
                        'status'          => 0,
                        'total_rows'      => 2,
                        'totals'          => {
                            'DirectBannerClicks_a'        => '3537',
                            'DirectBannerClicks_absdelta' => -531,
                            'DirectBannerClicks_b'        => '4068',
                            'DirectBannerClicks_delta'    => '-13.0530973451327',
                            'MixedPartnerPrice_a'         => '44767232990',
                            'MixedPartnerPrice_absdelta'  => 6823787535,
                            'MixedPartnerPrice_b'         => '37943445455',
                            'MixedPartnerPrice_delta'     => '17.9841009512245',
                            'RenderShows_a'               => '543992',
                            'RenderShows_absdelta'        => 76792,
                            'RenderShows_b'               => '467200',
                            'RenderShows_delta'           => '16.4366438356164'
                        }
                    }
                },
            },
            {
                name  => 'ComplexBlockID',
                input => {
                    date_from    => '20160703',
                    date_to      => '20160703',
                    limit        => 50,
                    offset       => 0,
                    stat_type    => $MOL_REPORT_TYPE_MM,
                    mol_response => {
                        'data' =>
                          [['mobile_app_rtb-520620-2', '96657928248'], ['mobile_app_rtb-595972-1', '117836962972']],
                        'duration'        => '0.112',
                        'error_text'      => '',
                        'header'          => ['ComplexBlockID', 'RevenueMM'],
                        'host-aggregator' => 'localhost',
                        'stat_time'       => 0,
                        'status'          => 0,
                        'total_rows'      => 2,
                        'totals'          => {'RevenueMM' => '214494891220'}
                      }

                }
            }
        );

        my @result;
        foreach my $t (@tests) {
            my $get_statistics2 = $app->bk_statistics->_convert_mol_response_to_get_statistics2(%{$t->{'input'}});
            push @result, [$t->{'name'}, $get_statistics2];
        }

        my $has_data = get_test_data_and_update_if_needed('data.json', \@result);
        eq_or_diff(\@result, $has_data, 'checks');
    },
    init => ['bk_statistics'],
);
