use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Partner::Utils;

run_tests(
    sub {
        my ($app) = @_;

        change_cur_user($app, 'mocked-yan-manager');

        my @tests = (
            {
                name  => 'simple convert',
                input => {
                    data => [
                        [1, 173198, 31940,     92,],
                        [1, 158872, 86690,     286,],
                        [1, 134793, 5823636,   75831,],
                        [1, 134783, 80415551,  248895,],
                        [1, 160861, 6226,      16,],
                        [1, 148813, 31180,     139,],
                        [1, 132169, 381746861, 450661,],
                        [1, 165245, 0,         0,],
                        [1, 46287,  224463,    936,],
                        [1, 19348,  350543,    867,],
                        [1, 139125, 60634,     105,],
                        [1, 147060, 0,         0,],
                        [1, 140837, 44727,     104,],
                        [1, 149889, 1035,      1,],
                        [1, 168816, 2841,      22,],
                    ],
                    duration          => 0.715,
                    error_text        => "",
                    header            => ["DSPID", "PageID", "Shows", "Clicks",],
                    'host-aggregator' => "bsfastexport02h.yabs.yandex.ru",
                    stat_time         => 20160722171826,
                    status            => 0,
                    total_rows        => 329,
                    totals            => {
                        Clicks => 930030,
                        Shows  => 541328534,
                    },
                },
                output => [
                    {DSPID => {eq => [1]}, PageID => {eq => [173198]}},
                    {DSPID => {eq => [1]}, PageID => {eq => [158872]}},
                    {DSPID => {eq => [1]}, PageID => {eq => [134793]}},
                    {DSPID => {eq => [1]}, PageID => {eq => [134783]}},
                    {DSPID => {eq => [1]}, PageID => {eq => [160861]}},
                    {DSPID => {eq => [1]}, PageID => {eq => [148813]}},
                    {DSPID => {eq => [1]}, PageID => {eq => [132169]}},
                    {DSPID => {eq => [1]}, PageID => {eq => [165245]}},
                    {DSPID => {eq => [1]}, PageID => {eq => [46287]}},
                    {DSPID => {eq => [1]}, PageID => {eq => [19348]}},
                    {DSPID => {eq => [1]}, PageID => {eq => [139125]}},
                    {DSPID => {eq => [1]}, PageID => {eq => [147060]}},
                    {DSPID => {eq => [1]}, PageID => {eq => [140837]}},
                    {DSPID => {eq => [1]}, PageID => {eq => [149889]}},
                    {DSPID => {eq => [1]}, PageID => {eq => [168816]}},
                ],
            },
            {
                name  => 'simple convert',
                input => {
                    data => [
                        [101, "context_on_site_rtb-101-1",  "Russia",  31940,   92,],
                        [101, "context_on_site_rtb-101-2",  "Belarus", 86690,   286,],
                        [102, "context_on_site_rtb-102-13", "France",  5823636, 75831,],
                    ],
                    duration          => 0.715,
                    error_text        => "",
                    header            => ["PageID", "ComplexBlockID", "RegionName", "Shows", "Clicks",],
                    'host-aggregator' => "bsfastexport02h.yabs.yandex.ru",
                    stat_time         => 20160722171826,
                    status            => 0,
                    total_rows        => 329,
                    totals            => {
                        Clicks => 930030,
                        Shows  => 541328534,
                    },
                },
                output => [
                    {
                        'ComplexBlockID' => {'eq' => ['context_on_site_rtb-101-1']},
                        'PageID'         => {'eq' => [101]},
                        'RegionName'     => {'eq' => ['Russia']}
                    },
                    {
                        'ComplexBlockID' => {'eq' => ['context_on_site_rtb-101-2']},
                        'PageID'         => {'eq' => [101]},
                        'RegionName'     => {'eq' => ['Belarus']}
                    },
                    {
                        'ComplexBlockID' => {'eq' => ['context_on_site_rtb-102-13']},
                        'PageID'         => {'eq' => [102]},
                        'RegionName'     => {'eq' => ['France']}
                    }
                ],
            },
        );

        foreach my $t (@tests) {
            is_deeply($app->bk_statistics->_get_additional_where_from_mol_answer($t->{'input'}),
                $t->{'output'}, $t->{'name'},);
        }
    },
);
