use strict;
use warnings FATAL => 'all';

package Exception::API::HTTPMOL::TooManyGroupBy;

package main;

use qbit qw(gettext);
use Test::More;
use Test::Partner::Utils;
require Application::Model::BKStatistics;

sub main_in_test {

    mock_curdate('2016-07-26 15:05:58');

    my @tests = (
        {
            input  => ['2016-07-01', '2016-07-03'],
            output => ['20160701',   '20160703'],
        },
        {
            input  => ['2016-04-02', '2016-06-30'],
            output => ['20160402',   '20160630'],
        },
        {
            input  => '7days',
            output => ['20160720', '20160726'],
        },
        {
            input  => '30days',
            output => ['20160627', '20160726'],
        },
        {
            input  => '90days',
            output => ['20160428', '20160726'],
        },
        {
            input  => '365days',
            output => ['20150728', '20160726'],
        },
        {
            input  => 'today',
            output => ['20160726', '20160726'],
        },
        {
            input  => 'yesterday',
            output => ['20160725', '20160725'],
        },
        {
            input  => '10days',
            output => ['20160717', '20160726'],
        },
        {
            input  => 'thismonth',
            output => ['20160701', '20160726'],
        },
        {
            input  => 'lastmonth',
            output => ['20160601', '20160630'],
        },
        {
            input  => 'thisyear',
            output => ['20160101', '20161231'],
        },
        {
            input  => 'pastyear',
            output => ['20150101', '20151231'],
        },
    );

    my $self;

    foreach my $t (@tests) {
        my $msg;

        if (ref($t->{'input'}) eq '') {
            $msg = $t->{'input'};
        } else {
            $msg = sprintf "['%s', '%s']", $t->{'input'}[0], $t->{'input'}[1];
        }

        is_deeply([Application::Model::BKStatistics::_get_dates_from_period($self, $t->{'input'})],
            $t->{'output'}, $msg,);
    }

    eval {Application::Model::BKStatistics::_get_dates_from_period($self, 'INCORRECT PERIOD');};

    is($@->message, gettext("Incorrect period '%s'", 'INCORRECT PERIOD'),);

    done_testing();
}
main_in_test();
