use strict;
use warnings FATAL => 'all';

package Exception::API::HTTPMOL::TooManyGroupBy;

package main;

use Test::More;
require Application::Model::BKStatistics;

sub main_in_test {

    my %tests = (
        1_000_000      => 1,
        20933630247771 => 20933630.25,
        41555040973201 => 41555040.97,
    );

    foreach my $mol_number (keys(%tests)) {
        is(Application::Model::BKStatistics::_get_float_from_mol_number(undef, $mol_number),
            $tests{$mol_number}, "$mol_number => $tests{$mol_number}");
    }

    done_testing();
}
main_in_test();
