use qbit;
use Test::Partner2::Simple;
use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        my @date_tests = (
            {
                in  => undef,
                out => undef,
            },
            {
                in  => [],
                out => undef,
            },
            {
                in  => ['date|day'],
                out => 'day',
            },
            {
                in  => ['geo|country', 'date|day'],
                out => 'day',
            },
            {
                in  => ['date|day', 'geo|country'],
                out => 'day',
            },
            {
                in  => ['bbb', 'date|month', 'bbb'],
                out => 'month',
            },
            {
                in  => ['bbb', 'date|NNN', 'bbb'],
                out => undef,
            },
        );

        foreach my $test (@date_tests) {
            is(
                $app->bk_statistics->_get_group($test->{in}, 'date', $app->bk_statistics->_get_date_groups()),
                $test->{out}, sprintf('%s => %s', to_json($test->{in}), to_json($test->{out})),
              );
        }

        my @geo_tests = (
            {
                in  => undef,
                out => undef,
            },
            {
                in  => [],
                out => undef,
            },
            {
                in  => ['date|day'],
                out => undef,
            },
            {
                in  => ['geo|country', 'date|day'],
                out => 'country',
            },
            {
                in  => ['date|day', 'geo|country'],
                out => 'country',
            },
            {
                in  => ['bbb', 'geo|country', 'bbb'],
                out => 'country',
            },
            {
                in  => ['bbb', 'geo|NNN', 'bbb'],
                out => undef,
            },
        );

        foreach my $test (@geo_tests) {
            is(
                $app->bk_statistics->_get_group($test->{in}, 'geo', $app->bk_statistics->_get_region_levels()),
                $test->{out}, sprintf('%s => %s', to_json($test->{in}), to_json($test->{out})),
              );
        }

    },
);
