use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use qbit;

use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        my $tests = [
            {
                input => {
                    limit      => 50,
                    offset     => 0,
                    total_rows => 860,
                },
                is_last_page => 0,
            },
            {
                input => {
                    limit      => 50,
                    offset     => 0,
                    total_rows => 49,
                },
                is_last_page => 1,
            },
            {
                input => {
                    limit      => 50,
                    offset     => 0,
                    total_rows => 50,
                },
                is_last_page => 1,
            },
            {
                input => {
                    limit      => 50,
                    offset     => 0,
                    total_rows => 51,
                },
                is_last_page => 0,
            },
            {
                input => {
                    limit      => 1,
                    offset     => 0,
                    total_rows => 3,
                },
                is_last_page => 0,
            },
            {
                input => {
                    limit      => 1,
                    offset     => 1,
                    total_rows => 3,
                },
                is_last_page => 0,
            },
            {
                input => {
                    limit      => 1,
                    offset     => 2,
                    total_rows => 3,
                },
                is_last_page => 1,
            },
            {
                input => {
                    limit      => 1,
                    offset     => 3,
                    total_rows => 3,
                },
                # выдаем is_last_page true в случае если выбранное окно находится
                # за пределами значений
                is_last_page => 1,
            },
        ];

        foreach my $test (@{$tests}) {
            is(
                !!$app->bk_statistics->_is_last_page(%{$test->{input}}),
                !!$test->{is_last_page},
                sprintf(
                    '_is_last_page %s => %s',
                    to_json($test->{input}, canonical => 1),
                    ($test->{is_last_page} ? 'true' : 'false'),
                ),
              );
        }

    },
    dont_create_database => 1,
    do_not_die_on_fail   => 1,
);
