use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Exception;
use Test::More;

use Test::Partner2::Simple;
use Test::Partner::Utils;

require Application::Model::BKStatistics;

mock_curdate('2016-07-26 15:05:58');

my @tests = (
    {
        input   => ['2016-07-01', '2016-07-03'],
        message => '1 array = not 2 2-element arrays',
    },
    {
        input => [[], []],
        message => '2 array with no elements = not 2 2-element arrays',
    },
    {
        input => [[], ['2016-04-02', '2016-06-30']],
        message => '2 array, 1st with no elements = not 2 2-element arrays',
    },
    {
        input => [['2016-04-02', '2016-06-30'], []],
        message => '2 array, 2nd with no elements = not 2 2-element arrays',
    },
    {
        input   => [['2016-04-02', '2016-06-30']],
        message => '1 array instead of 2 = not 2 2-element arrays',
    },
    {
        input => ['today', ['2016-04-02', '2016-06-30']],
        message => 'string instead of array = not 2 2-element arrays',
    },
    {
        input => [['2016-05-02', '2016-05-02'], ['2016-04-02', '2016-04-01']],
        message => 'periods have different lenghts = wrong periods',
    },
    {
        input => [['2016-04-02', '2016-04-01'], ['2016-05-02', '2016-05-01']],
        message => '2nd period is earlier = wrong periods',
    },
    {
        input => [['2016-05-01', '2016-05-02'], ['2016-04-02', '2016-04-01']],
        message => 'periods are in different directions = wrong periods',
    },
    {
        input => [['2016-05-02', '2016-05-01'], ['2016-04-02', '2016-04-01']],
        message => 'direction within a period is wrong = wrong periods',
    },
    {
        ok      => 1,
        input   => [['2016-05-01', '2016-05-02'], ['2016-04-01', '2016-04-02']],
        message => 'correct periods',
    },
);

run_tests(
    sub {
        my ($app) = @_;

        foreach my $t (grep {!exists $_->{ok}} @tests) {
            throws_ok(
                sub {
                    Application::Model::BKStatistics::_validate_comparing_periods($t->{'input'});
                },
                'Exception::Validation::BadArguments',
                'OK exception for ' . to_json($t->{'input'}) . ' : ' . $t->{'message'},
            );
        }

        foreach my $t (grep {exists $_->{ok}} @tests) {
            lives_ok(
                sub {
                    Application::Model::BKStatistics::_validate_comparing_periods($t->{'input'});
                },
                'NO exception for ' . to_json($t->{'input'}) . ' : ' . $t->{'message'},
            );
        }

    }
);
