use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::Deep;
require Application::Model::BKStatistics;

use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        no warnings 'once';
        my @fields = @Application::Model::BKStatistics::FIELDS;

        my @available_for_everyone_fields;
        my @fields_with_right_access;

        foreach my $f (sort @fields) {
            if ($f->{available_for_everyone}) {
                push(@available_for_everyone_fields, $f->{partner2_id});
            } else {
                push(@fields_with_right_access, $f->{partner2_id});
            }
        }

        my $expected = get_test_data_and_update_if_needed(
            "data.json",
            {
                everyone     => [sort @available_for_everyone_fields],
                right_access => [sort @fields_with_right_access],
            }
        );

        cmp_bag(
            \@available_for_everyone_fields,
            $expected->{everyone}, "expected list of fields that are available for everyone",
        );

        cmp_bag(
            \@fields_with_right_access,
            $expected->{right_access},
            "expected list of fields that are protected with rights",
        );
    },
);
